/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution.matrix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.distribution.matrix.coordinate.GosplCoordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AFullNDimensionalMatrix<T extends Number>
implements INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> {
    private GSSurveyType dataType;
    private final Set<Attribute<? extends IValue>> dimensions;
    protected final Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> matrix;
    private ACoordinate<Attribute<? extends IValue>, IValue> emptyCoordinate = null;
    protected String label = null;
    protected List<String> genesis = new LinkedList<String>();

    protected AFullNDimensionalMatrix(Set<Attribute<? extends IValue>> set, GSSurveyType gSSurveyType) {
        this.dimensions = new HashSet<Attribute<? extends IValue>>(set);
        this.matrix = new ConcurrentHashMap<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>>(set.stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).reduce(1, (n, n2) -> n * n2) / 4);
        this.dataType = gSSurveyType;
        this.emptyCoordinate = new GosplCoordinate(Collections.emptyMap());
        this.label = set.stream().map(attribute -> attribute.getAttributeName().length() > 3 ? attribute.getAttributeName().substring(0, 3) : attribute.getAttributeName()).collect(Collectors.joining(" x "));
    }

    protected AFullNDimensionalMatrix(Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> map) {
        this.dimensions = map.keySet().stream().flatMap(aCoordinate -> aCoordinate.getDimensions().stream()).collect(Collectors.toSet());
        this.matrix = map;
    }

    public List<String> getGenesisAsList() {
        return Collections.unmodifiableList(this.genesis);
    }

    @Override
    public String getGenesisAsString() {
        return String.join((CharSequence)"->", this.genesis);
    }

    @Override
    public void inheritGenesis(AFullNDimensionalMatrix<?> aFullNDimensionalMatrix) {
        this.genesis.addAll(aFullNDimensionalMatrix.getGenesisAsList());
    }

    @Override
    public void addGenesis(String string) {
        this.genesis.add(string);
    }

    @Override
    public boolean isSegmented() {
        return false;
    }

    @Override
    public GSSurveyType getMetaDataType() {
        return this.dataType;
    }

    public boolean setMetaDataType(GSSurveyType gSSurveyType) {
        if (this.dataType != null && this.dataType.equals((Object)gSSurveyType)) {
            return false;
        }
        this.dataType = gSSurveyType;
        return true;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public int size() {
        return this.matrix.size();
    }

    @Override
    public int getDegree() {
        return this.getDimensions().stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size() - 1).reduce(1, (n, n2) -> n * n2);
    }

    @Override
    public final boolean addValue(T t, String ... stringArray) {
        return this.addValue(GosplCoordinate.createCoordinate(this.dimensions, stringArray), t);
    }

    @Override
    public final boolean setValue(T t, String ... stringArray) {
        return this.setValue(GosplCoordinate.createCoordinate(this.dimensions, stringArray), t);
    }

    @Override
    public Set<Attribute<? extends IValue>> getDimensions() {
        return Collections.unmodifiableSet(this.dimensions);
    }

    @Override
    public Map<Attribute<? extends IValue>, Set<? extends IValue>> getDimensionsAsAttributesAndValues() {
        return this.dimensions.stream().collect(Collectors.toMap(Function.identity(), attribute -> attribute.getValueSpace().getValues()));
    }

    @Override
    public Attribute<? extends IValue> getDimension(IValue iValue) {
        if (!this.getDimensions().contains(iValue.getValueSpace().getAttribute())) {
            throw new NullPointerException("aspect " + String.valueOf(iValue) + " does not fit any known dimension");
        }
        return this.dimensions.stream().filter(attribute -> attribute.getValueSpace().contains(iValue) || attribute.getEmptyValue().equals(iValue)).findFirst().orElse(null);
    }

    @Override
    public Set<IValue> getAspects() {
        return this.dimensions.stream().flatMap(attribute -> attribute.getValueSpace().getValues().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<IValue> getAspects(Attribute<? extends IValue> attribute) {
        if (!this.dimensions.contains(attribute)) {
            throw new NullPointerException("dimension " + String.valueOf(attribute) + " is not present in the joint distribution");
        }
        return Collections.unmodifiableSet(attribute.getValueSpace().getValues());
    }

    @Override
    public Set<IValue> getValues(String ... stringArray) throws IllegalArgumentException {
        HashSet<IValue> hashSet = new HashSet<IValue>();
        Map map = this.getDimensionsAsAttributesAndValues().keySet().stream().collect(Collectors.toMap(Attribute::getAttributeName, Function.identity()));
        if (stringArray.length / 2 != map.size()) {
            throw new IllegalArgumentException("you should pass pairs of attribute name and corresponding value, such as attribute 1 name, value for attribute 1, attribute 2 name, value for attribute 2...");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            Attribute attribute = (Attribute)map.get(string);
            if (attribute == null) {
                throw new IllegalArgumentException("unknown attribute " + string);
            }
            hashSet.add((IValue)attribute.getValueSpace().addValue(string2));
            n += 2;
        }
        return hashSet;
    }

    @Override
    public Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> getMatrix() {
        return Collections.unmodifiableMap(this.matrix);
    }

    @Override
    public LinkedHashMap<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> getOrderedMatrix() {
        return this.matrix.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (aControl, aControl2) -> aControl, LinkedHashMap::new));
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getEmptyCoordinate() {
        return this.emptyCoordinate;
    }

    @Override
    public AControl<T> getVal() {
        AControl aControl = this.getNulVal();
        for (AControl<T> aControl2 : this.matrix.values()) {
            this.getSummedControl(aControl, aControl2);
        }
        return aControl;
    }

    @Override
    public AControl<T> getVal(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        AControl<T> aControl = this.matrix.get(aCoordinate);
        if (aControl == null) {
            if (this.isCoordinateCompliant(aCoordinate)) {
                return this.getNulVal();
            }
            throw new NullPointerException("Coordinate " + String.valueOf(aCoordinate) + " is absent from this control table (" + this.hashCode() + ")");
        }
        return aControl;
    }

    @Override
    public AControl<T> getVal(IValue iValue) {
        return this.getVal(iValue, false);
    }

    @Override
    public AControl<T> getVal(IValue iValue, boolean bl) {
        if (this.matrix.keySet().stream().noneMatch(aCoordinate -> aCoordinate.contains(iValue))) {
            if (bl) {
                return this.getNulVal();
            }
            throw new NullPointerException("Aspect " + String.valueOf(iValue) + " is absent from this control table (" + this.hashCode() + ")");
        }
        return this.matrix.entrySet().stream().filter(entry -> ((ACoordinate)entry.getKey()).values().contains(iValue)).map(Map.Entry::getValue).reduce(this.getNulVal(), this::getSummedControl);
    }

    @Override
    public AControl<T> getVal(Collection<IValue> collection) {
        return this.getVal(collection, false);
    }

    @Override
    public AControl<T> getVal(Collection<IValue> collection, boolean bl) {
        HashSet<IValue> hashSet = new HashSet<IValue>(collection);
        if (!collection.stream().allMatch(iValue -> this.matrix.keySet().stream().anyMatch(aCoordinate -> aCoordinate.contains(iValue)))) {
            if (bl) {
                return this.getNulVal();
            }
            if (collection.stream().filter(iValue -> iValue.getValueSpace().getEmptyValue().equals(iValue) && this.getDimensions().contains(iValue.getValueSpace().getAttribute())).allMatch(iValue -> this.matrix.keySet().stream().anyMatch(aCoordinate -> aCoordinate.contains(iValue)))) {
                hashSet.removeAll(collection.stream().filter(iValue -> iValue.getValueSpace().getEmptyValue().equals(iValue)).collect(Collectors.toSet()));
            } else {
                throw new NullPointerException("Aspect collection " + Arrays.toString(collection.toArray()) + " of size " + collection.size() + " is absent from this matrix (size = " + this.size() + " - attribute = " + Arrays.toString(this.getDimensions().toArray()) + ")");
            }
        }
        Map map = hashSet.stream().collect(Collectors.groupingBy(iValue -> iValue.getValueSpace().getAttribute(), Collectors.mapping(Function.identity(), Collectors.toSet())));
        return this.matrix.entrySet().stream().filter(entry -> map.values().stream().allMatch(set -> ((ACoordinate)entry.getKey()).values().stream().anyMatch(set::contains))).map(Map.Entry::getValue).reduce(this.getNulVal(), this::getSummedControl);
    }

    @Override
    public final AControl<T> getVal(String ... stringArray) {
        HashSet<IValue> hashSet = new HashSet<IValue>();
        Map map = this.dimensions.stream().collect(Collectors.toMap(Attribute::getAttributeName, Function.identity()));
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("values should be passed in even count, such as attribute 1 name, value for attribute 1, attribute 2 name, value for attribute 2...");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            Attribute attribute = (Attribute)map.get(string);
            if (attribute == null) {
                throw new IllegalArgumentException("unknown attribute " + string);
            }
            hashSet.add((IValue)attribute.getValueSpace().getValue(string2));
            n += 2;
        }
        return this.getVal((Collection<IValue>)hashSet);
    }

    @Override
    public final AControl<T> getVal(IValue ... iValueArray) {
        return this.getVal((Collection<IValue>)new HashSet<IValue>(Arrays.asList(iValueArray)));
    }

    @Override
    public boolean isCoordinateCompliant(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        return this.dimensions.containsAll(aCoordinate.getDimensions()) && this.dimensions.size() == aCoordinate.getDimensions().size();
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getCoordinates(Set<IValue> set) {
        if (this.matrix.isEmpty()) {
            return Collections.emptyList();
        }
        Map map = set.stream().filter(iValue -> this.getDimensions().contains(iValue.getValueSpace().getAttribute())).collect(Collectors.groupingBy(iValue -> iValue.getValueSpace().getAttribute(), Collectors.mapping(Function.identity(), Collectors.toSet())));
        return this.matrix.keySet().stream().filter(aCoordinate -> map.values().stream().allMatch(set -> set.stream().anyMatch(aCoordinate::contains))).toList();
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getOrCreateCoordinates(Set<IValue> set) {
        Collection<ACoordinate<Attribute<? extends IValue>, IValue>> collection = this.getCoordinates(set);
        if (collection.isEmpty()) {
            collection = new HashSet<ACoordinate<Attribute<? extends IValue>, IValue>>();
            Map map = set.stream().filter(iValue -> this.getDimensions().contains(iValue.getValueSpace().getAttribute())).collect(Collectors.groupingBy(iValue -> iValue.getValueSpace().getAttribute(), Collectors.mapping(Function.identity(), Collectors.toSet())));
            for (List list : Sets.cartesianProduct(map.values().stream().toList())) {
                Map<Attribute<? extends IValue>, IValue> map2 = list.stream().collect(Collectors.toMap(iValue -> (Attribute)iValue.getValueSpace().getAttribute(), Function.identity()));
                collection.add(new GosplCoordinate(map2));
            }
        }
        return collection;
    }

    @Override
    public Attribute<? extends IValue> getDimension(String string3) throws IllegalArgumentException {
        for (Attribute<? extends IValue> attribute : this.dimensions) {
            if (!attribute.getAttributeName().equals(string3)) continue;
            return attribute;
        }
        throw new IllegalArgumentException("unknown dimension " + string3 + "; available dimensions are " + this.dimensions.stream().map(Attribute::getAttributeName).reduce("", (string, string2) -> string + "," + string2));
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getCoordinates(String ... stringArray) throws IllegalArgumentException {
        return this.getCoordinates(this.getValues(stringArray));
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getCoordinate(Set<IValue> set) throws NullPointerException {
        List<ACoordinate> list = this.matrix.keySet().stream().filter(aCoordinate -> aCoordinate.containsAll(set) && aCoordinate.size() == set.size()).toList();
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new NullPointerException("Trying to access coordinate with values " + Arrays.toString(set.toArray()) + " but find " + list.size() + " associated coordinate(s) in the matrix " + this.getLabel());
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getCoordinate(String ... stringArray) throws IllegalArgumentException {
        Collection<ACoordinate<Attribute<IValue>, IValue>> collection = this.getCoordinates(stringArray);
        if (collection.size() > 1) {
            throw new IllegalArgumentException("these coordinates do not map to a single cell of the matrix");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("these coordinates do not map to any cell in the matrix");
        }
        return collection.iterator().next();
    }

    @Override
    public Set<IValue> getEmptyReferentCorrelate(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        Map map = this.getDimensions().stream().filter(attribute -> !attribute.getReferentAttribute().equals(attribute) && aCoordinate.getDimensions().contains(attribute.getReferentAttribute())).collect(Collectors.toMap(Function.identity(), attribute -> (IValue)aCoordinate.getMap().get(attribute.getReferentAttribute())));
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        Set set = map.entrySet().stream().flatMap(entry -> ((Attribute)entry.getKey()).findMappedAttributeValues((IValue)entry.getValue()).stream()).filter(iValue -> iValue.getValueSpace().getEmptyValue().equals(iValue)).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        return this.getDimensions().stream().filter(attribute -> set.stream().noneMatch(iValue -> iValue.getValueSpace().getAttribute().equals(attribute))).map(Attribute::getEmptyValue).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        int n3 = this.getDimensions().stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).reduce(1, (n, n2) -> n * n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-- Matrix: ").append(this.dimensions.size()).append(" dimensions and ").append(this.dimensions.stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).sum()).append(" aspects (theoretical size:").append(n3).append(")--\n");
        AControl aControl = this.getNulVal();
        for (Attribute<? extends IValue> attribute2 : this.dimensions) {
            stringBuilder.append(" -- dimension: ").append(attribute2.getAttributeName());
            stringBuilder.append(" with ").append(attribute2.getValueSpace().getValues().size()).append(" aspects -- \n");
            for (IValue iValue : attribute2.getValueSpace().getValues()) {
                AControl<T> aControl2 = null;
                try {
                    aControl2 = this.getVal(iValue);
                }
                catch (NullPointerException nullPointerException) {
                    aControl2 = aControl;
                }
                stringBuilder.append("| ").append(iValue).append(": ").append(aControl2).append("\n");
            }
        }
        stringBuilder.append(" ----------------------------------- \n");
        return stringBuilder.toString();
    }

    @Override
    public String toCsv(char c) {
        ArrayList<Attribute<IValue>> arrayList = new ArrayList<Attribute<IValue>>(this.getDimensions());
        AControl aControl = this.getNulVal();
        StringBuilder stringBuilder = new StringBuilder();
        for (Attribute object : arrayList) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(c);
            }
            stringBuilder.append(object.getAttributeName());
        }
        stringBuilder.append(c).append("value\n");
        for (ACoordinate aCoordinate : this.matrix.keySet()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Attribute attribute : arrayList) {
                if (!stringBuilder2.isEmpty()) {
                    stringBuilder2.append(c);
                }
                if (aCoordinate.values().stream().noneMatch(iValue -> iValue.getValueSpace().getAttribute().equals(attribute))) {
                    stringBuilder2.append(" ");
                    continue;
                }
                String string = aCoordinate.values().stream().filter(iValue -> iValue.getValueSpace().getAttribute().equals(attribute)).findFirst().get().getStringValue();
                if (string.isEmpty()) {
                    string = "empty value";
                }
                stringBuilder2.append(string);
            }
            AControl<T> aControl2 = this.getVal(aCoordinate);
            stringBuilder.append((CharSequence)stringBuilder2).append(c).append(aControl2 == null ? aControl : aControl2.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String toMatrixCsv(char c) {
        Object object;
        Object object22;
        ArrayList<Attribute<IValue>> arrayList;
        List list2 = arrayList.subList(0, ((arrayList = new ArrayList<Attribute<IValue>>(this.getDimensions())).size() % 2 == 0 ? arrayList.size() / 2 : arrayList.size() / 2 + 1) + 1);
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : list2) {
            arrayList2.add(new ArrayList(((Attribute)object22).getValueSpace().getValues()));
        }
        object22 = Lists.cartesianProduct(arrayList2);
        List list3 = arrayList.subList((arrayList.size() % 2 == 0 ? arrayList.size() / 2 : arrayList.size() / 2 + 1) + 1, arrayList.size() + 1);
        ArrayList arrayList3 = new ArrayList();
        Object object3 = list3.iterator();
        while (object3.hasNext()) {
            object = (Attribute)object3.next();
            arrayList3.add(new ArrayList(((Attribute)object).getValueSpace().getValues()));
        }
        object = Lists.cartesianProduct(arrayList3);
        object3 = new StringBuilder();
        int n = 0;
        while (n < object22.size()) {
            ((StringBuilder)object3).append(object.stream().map(list -> "").collect(Collectors.joining(String.valueOf(c))));
            int n2 = n++;
            ((StringBuilder)object3).append(c).append(object22.stream().map(list -> ((IValue)list.get(n2)).getStringValue()).collect(Collectors.joining(String.valueOf(c))));
            ((StringBuilder)object3).append("\n");
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            List list4 = (List)iterator.next();
            ((StringBuilder)object3).append(list4.stream().map(IValue::getStringValue).collect(Collectors.joining(String.valueOf(c))));
            Iterator iterator2 = object22.iterator();
            while (iterator2.hasNext()) {
                List list5 = (List)iterator2.next();
                ((StringBuilder)object3).append(c).append(this.getVal(Streams.concat((Stream[])new Stream[]{list5.stream(), list4.stream()}).collect(Collectors.toSet()), true).getValue());
            }
            ((StringBuilder)object3).append("\n");
        }
        return ((StringBuilder)object3).toString();
    }

    @Override
    public boolean checkAllCoordinatesHaveValues() {
        return this.matrix.size() == this.dimensions.stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).reduce(1, (n, n2) -> n * n2);
    }

    @Override
    public boolean checkGlobalSum() {
        return switch (this.dataType) {
            case GSSurveyType.GlobalFrequencyTable -> {
                if (Math.abs(((Number)this.getVal().getValue()).doubleValue() - 1.0) < Math.pow(10.0, -4.0)) {
                    yield true;
                }
                yield false;
            }
            case GSSurveyType.LocalFrequencyTable -> true;
            case GSSurveyType.Sample -> throw new IllegalStateException("This matrix cannot be of type " + String.valueOf((Object)this.dataType));
            case GSSurveyType.ContingencyTable -> true;
            default -> throw new IllegalStateException("unknown state " + String.valueOf((Object)this.dataType));
        };
    }

    private AControl<T> getSummedControl(AControl<T> aControl, AControl<T> aControl2) {
        return aControl.add(aControl2);
    }
}

