/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution.matrix;

import core.metamodel.io.GSSurveyType;
import core.util.data.GSDataParser;
import gospl.distribution.exception.IllegalNDimensionalMatrixAccess;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LRUMap;

public class CachedNDimensionalMatrix<D, A, T extends Number>
implements INDimensionalMatrix<D, A, T> {
    public static final int MAX_SIZE = 100000;
    private final INDimensionalMatrix<D, A, T> m;
    private final LRUMap<Object, AControl<T>> cachedAspect2value;
    private long hits = 0L;
    private long missed = 0L;

    public CachedNDimensionalMatrix(INDimensionalMatrix<D, A, T> iNDimensionalMatrix) {
        this.m = iNDimensionalMatrix;
        this.cachedAspect2value = new LRUMap(Math.min(100000, iNDimensionalMatrix.size()));
    }

    public long getHits() {
        return this.hits;
    }

    public long getMissed() {
        return this.missed;
    }

    @Override
    public final AControl<T> getVal(ACoordinate<D, A> aCoordinate) {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get(aCoordinate);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal(aCoordinate);
            this.cachedAspect2value.put(aCoordinate, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    public final AControl<T> getVal(A a) throws IllegalNDimensionalMatrixAccess {
        return this.getVal(a, false);
    }

    @Override
    public AControl<T> getVal(A a, boolean bl) {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get(a);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal(a);
            this.cachedAspect2value.put(a, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    public final AControl<T> getVal(Collection<A> collection) {
        return this.getVal(collection, false);
    }

    @Override
    public final AControl<T> getVal(Collection<A> collection, boolean bl) {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get(collection);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal(collection);
            this.cachedAspect2value.put(collection, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    public final AControl<T> getVal(String ... stringArray) {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get((Object)stringArray);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal(stringArray);
            this.cachedAspect2value.put((Object)stringArray, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    @SafeVarargs
    public final AControl<T> getVal(A ... AArray) {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get(AArray);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal(AArray);
            this.cachedAspect2value.put(AArray, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    public final AControl<T> getVal() {
        AControl<T> aControl = (AControl<T>)this.cachedAspect2value.get(null);
        if (aControl == null) {
            ++this.missed;
            aControl = this.m.getVal();
            this.cachedAspect2value.put(null, aControl);
        } else {
            ++this.hits;
        }
        return aControl;
    }

    @Override
    public final Set<A> getValues(String ... stringArray) throws IllegalArgumentException {
        return this.m.getValues(stringArray);
    }

    @Override
    public final boolean addValue(ACoordinate<D, A> aCoordinate, AControl<? extends Number> aControl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addValue(ACoordinate<D, A> aCoordinate, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addValue(T t, String ... stringArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean setValue(ACoordinate<D, A> aCoordinate, AControl<? extends Number> aControl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean setValue(ACoordinate<D, A> aCoordinate, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean setValue(T t, String ... stringArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Map<ACoordinate<D, A>, AControl<T>> getMatrix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final LinkedHashMap<ACoordinate<D, A>, AControl<T>> getOrderedMatrix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ACoordinate<D, A> getEmptyCoordinate() {
        return this.m.getEmptyCoordinate();
    }

    @Override
    public final Set<D> getDimensions() {
        return this.m.getDimensions();
    }

    @Override
    public final D getDimension(String string) throws IllegalArgumentException {
        return this.m.getDimension(string);
    }

    @Override
    public final Map<D, Set<? extends A>> getDimensionsAsAttributesAndValues() {
        return this.m.getDimensionsAsAttributesAndValues();
    }

    @Override
    public final D getDimension(A a) {
        return this.m.getDimension(a);
    }

    @Override
    public final Set<A> getAspects() {
        return this.m.getAspects();
    }

    @Override
    public final Set<A> getAspects(D d) {
        return this.m.getAspects(d);
    }

    @Override
    public final int size() {
        return this.m.size();
    }

    @Override
    public final int getDegree() {
        return this.m.getDegree();
    }

    @Override
    public final boolean isSegmented() {
        return this.m.isSegmented();
    }

    @Override
    public final GSSurveyType getMetaDataType() {
        return this.m.getMetaDataType();
    }

    @Override
    public final boolean isCoordinateCompliant(ACoordinate<D, A> aCoordinate) {
        return this.m.isCoordinateCompliant(aCoordinate);
    }

    @Override
    public Set<A> getEmptyReferentCorrelate(ACoordinate<D, A> aCoordinate) {
        return this.m.getEmptyReferentCorrelate(aCoordinate);
    }

    @Override
    public final Collection<ACoordinate<D, A>> getCoordinates(Set<A> set) {
        return this.m.getCoordinates(set);
    }

    @Override
    public Collection<ACoordinate<D, A>> getOrCreateCoordinates(Set<A> set) {
        return this.m.getOrCreateCoordinates(set);
    }

    @Override
    public final Collection<ACoordinate<D, A>> getCoordinates(String ... stringArray) throws IllegalArgumentException {
        return this.m.getCoordinates(stringArray);
    }

    @Override
    public ACoordinate<D, A> getCoordinate(Set<A> set) throws NullPointerException {
        return this.m.getCoordinate(set);
    }

    @Override
    public final ACoordinate<D, A> getCoordinate(String ... stringArray) throws IllegalArgumentException {
        return this.m.getCoordinate(stringArray);
    }

    @Override
    public final boolean checkAllCoordinatesHaveValues() {
        return this.m.checkAllCoordinatesHaveValues();
    }

    @Override
    public boolean checkGlobalSum() {
        return this.m.checkGlobalSum();
    }

    @Override
    public final String toCsv(char c) {
        return this.m.toCsv(c);
    }

    @Override
    public final AControl<T> getNulVal() {
        return this.m.getNulVal();
    }

    @Override
    public final AControl<T> getIdentityProductVal() {
        return this.m.getIdentityProductVal();
    }

    @Override
    public AControl<T> getAtomicVal() {
        return this.m.getAtomicVal();
    }

    @Override
    public final AControl<T> parseVal(GSDataParser gSDataParser, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void normalize() throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getLabel() {
        return this.m.getLabel();
    }

    @Override
    public final String getGenesisAsString() {
        return this.m.getGenesisAsString();
    }

    @Override
    public final void inheritGenesis(AFullNDimensionalMatrix<?> aFullNDimensionalMatrix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void addGenesis(String string) {
        throw new UnsupportedOperationException();
    }
}

