/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.co;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandomUtils;
import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.sampler.IEntitySampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.IntStream;

public class MicroDataSampler
implements IEntitySampler<IPopulation<ADemoEntity, Attribute<? extends IValue>>> {
    private final boolean clone;
    private Collection<ADemoEntity> sample;
    private ARouletteWheelSelection<Double, ADemoEntity> roulette;

    public MicroDataSampler() {
        this(true);
    }

    public MicroDataSampler(boolean bl) {
        this.clone = bl;
    }

    @Override
    public ADemoEntity draw() {
        ADemoEntity aDemoEntity = this.roulette != null ? (ADemoEntity)this.roulette.drawObject() : GenstarRandomUtils.oneOf(this.sample);
        return this.clone ? aDemoEntity.clone() : aDemoEntity;
    }

    @Override
    public Collection<ADemoEntity> draw(int n2) {
        HashSet<ADemoEntity> hashSet = new HashSet<ADemoEntity>();
        IntStream.range(0, n2).mapToObj(n -> this.draw()).forEach(aDemoEntity -> {
            boolean bl = hashSet.add((ADemoEntity)aDemoEntity);
        });
        return hashSet;
    }

    public Collection<ADemoEntity> drawWithChildrenNumber(int n) {
        ADemoEntity aDemoEntity;
        HashSet<ADemoEntity> hashSet = new HashSet<ADemoEntity>();
        int n2 = 0;
        do {
            aDemoEntity = this.draw();
            hashSet.add(aDemoEntity);
        } while ((n2 += aDemoEntity.getChildren().size()) < n);
        return hashSet;
    }

    @Override
    public void setSample(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, boolean bl) {
        if (bl) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<ADemoEntity> arrayList2 = new ArrayList<ADemoEntity>();
            for (ADemoEntity aDemoEntity : iPopulation) {
                arrayList.add(aDemoEntity.getWeight());
                arrayList2.add(aDemoEntity);
            }
            this.roulette = RouletteWheelSelectionFactory.getRouletteWheel(arrayList, arrayList2);
        } else {
            this.sample = iPopulation;
        }
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        throw new IllegalAccessError("There is not any objectives to setup in RandomSampler");
    }

    @Override
    public String toCsv(String string) {
        return null;
    }

    public boolean isEmpty() {
        return this.sample == null && this.roulette == null || this.sample != null && this.sample.isEmpty() || this.roulette != null && this.roulette.getKeys().isEmpty();
    }
}

