/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.sr;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandom;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.sampler.IDistributionSampler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GosplAliasSampler
implements IDistributionSampler {
    private List<ACoordinate<Attribute<? extends IValue>, IValue>> indexedKey;
    private List<Double> initProba;
    private int[] alias;
    private double[] probability;

    @Override
    public void setDistribution(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        if (aFullNDimensionalMatrix == null) {
            throw new NullPointerException();
        }
        if (aFullNDimensionalMatrix.getMatrix().isEmpty()) {
            throw new IllegalArgumentException("Cannot setup a sampler with an empty distribution matrix " + String.valueOf(aFullNDimensionalMatrix));
        }
        LinkedHashMap<ACoordinate<Attribute<IValue>, IValue>, AControl<Double>> linkedHashMap = aFullNDimensionalMatrix.getOrderedMatrix();
        this.indexedKey = new ArrayList(linkedHashMap.keySet());
        this.initProba = linkedHashMap.values().stream().map(AControl::getValue).toList();
        this.probability = new double[aFullNDimensionalMatrix.size()];
        this.alias = new int[aFullNDimensionalMatrix.size()];
        double d = 1.0 / (double)aFullNDimensionalMatrix.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(this.initProba);
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        ArrayDeque<Integer> arrayDeque2 = new ArrayDeque<Integer>();
        int n = 0;
        while (n < arrayList.size()) {
            if ((Double)arrayList.get(n) >= d) {
                arrayDeque2.add(n);
            } else {
                arrayDeque.add(n);
            }
            ++n;
        }
        while (!arrayDeque.isEmpty() && !arrayDeque2.isEmpty()) {
            n = (Integer)arrayDeque.removeLast();
            int n2 = (Integer)arrayDeque2.removeLast();
            this.probability[n] = (Double)arrayList.get(n) * (double)arrayList.size();
            this.alias[n] = n2;
            arrayList.set(n2, (Double)arrayList.get(n2) + (Double)arrayList.get(n) - d);
            if ((Double)arrayList.get(n2) >= 1.0 / (double)arrayList.size()) {
                arrayDeque2.add(n2);
                continue;
            }
            arrayDeque.add(n2);
        }
        while (!arrayDeque.isEmpty()) {
            this.probability[((Integer)arrayDeque.removeLast()).intValue()] = 1.0;
        }
        while (!arrayDeque2.isEmpty()) {
            this.probability[((Integer)arrayDeque2.removeLast()).intValue()] = 1.0;
        }
    }

    @Override
    public final Collection<ACoordinate<Attribute<? extends IValue>, IValue>> draw(int n2) {
        return IntStream.range(0, n2).mapToObj(n -> this.draw()).toList();
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> draw() {
        int n = GenstarRandom.getInstance().nextInt(this.probability.length);
        boolean bl = GenstarRandom.getInstance().nextDouble() < this.probability[n];
        return this.indexedKey.get(bl ? n : this.alias[n]);
    }

    @Override
    public String toCsv(String string) {
        ArrayList arrayList = new ArrayList(this.indexedKey.parallelStream().flatMap(aCoordinate -> aCoordinate.getDimensions().stream()).collect(Collectors.toSet()));
        StringBuilder stringBuilder = new StringBuilder().append(String.join((CharSequence)string, arrayList.stream().map(Attribute::getAttributeName).toList()));
        stringBuilder.append("; Probability\n");
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate2 : this.indexedKey) {
            String string2 = "";
            for (Attribute attribute : arrayList) {
                if (aCoordinate2.getDimensions().contains(attribute)) {
                    if (string2.isEmpty()) {
                        stringBuilder.append(string).append(aCoordinate2.getMap().get(attribute));
                        continue;
                    }
                    stringBuilder.append(string).append(aCoordinate2.getMap().get(attribute).getStringValue());
                    continue;
                }
                if (string2.isEmpty()) {
                    stringBuilder.append(" ");
                    continue;
                }
                stringBuilder.append(string).append(" ");
            }
            stringBuilder.append(string2).append(string).append(this.initProba.get(this.indexedKey.indexOf(aCoordinate2))).append("\n");
        }
        return stringBuilder.toString();
    }
}

