/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.constraint;

import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import spll.localizer.constraint.ASpatialConstraint;

public class SpatialConstraintMaxDistance
extends ASpatialConstraint {
    private Map<IShape, Double> distanceToEntities;

    public SpatialConstraintMaxDistance(IList<IShape> iList, Double d) {
        this.distanceToEntities = iList.stream().collect(Collectors.toMap(Function.identity(), iShape -> d));
    }

    public SpatialConstraintMaxDistance(Map<IShape, Double> map) {
        this.distanceToEntities = map;
    }

    @Override
    public IList<IShape> getCandidates(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        return GamaListFactory.createWithoutCasting((IType)Types.GEOMETRY, iContainer.listValue(iScope, (IType)Types.GEOMETRY, false).stream().filter(iShape -> this.distanceToEntities.keySet().stream().anyMatch(iShape2 -> iShape2.euclidianDistanceTo(iShape) <= this.distanceToEntities.get(iShape2))).toList());
    }

    @Override
    public boolean updateConstraint(IShape iShape) {
        return false;
    }

    @Override
    public void relaxConstraintOp(IList<IShape> iList) {
        iList.stream().forEach(iShape -> {
            Double d = this.distanceToEntities.put((IShape)iShape, this.distanceToEntities.get(iShape) + this.increaseStep);
        });
    }
}

