/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.constraint;

import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.stream.Collectors;
import spll.localizer.constraint.ASpatialConstraint;

public class SpatialConstraintMaxNumber
extends ASpatialConstraint {
    protected Map<IShape, Integer> nestCapacities;

    public SpatialConstraintMaxNumber(IList<IShape> iList, Double d) {
        this.nestCapacities = this.computeMaxPerNest(iList, d);
    }

    public SpatialConstraintMaxNumber(IList<IShape> iList, String string) {
        this.nestCapacities = this.computeMaxPerNest(iList, string);
    }

    @Override
    public void relaxConstraintOp(IList<IShape> iList) {
        for (IShape iShape : iList) {
            this.nestCapacities.put(iShape, Maths.round((Double)((double)this.nestCapacities.get(iShape).intValue() + this.increaseStep)));
        }
    }

    @Override
    public IList<IShape> getCandidates(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        return GamaListFactory.createWithoutCasting((IType)Types.GEOMETRY, iContainer.listValue(iScope, (IType)Types.GEOMETRY, false).stream().filter(iShape -> this.nestCapacities.get(iShape) > 0).toList());
    }

    @Override
    public boolean updateConstraint(IShape iShape) {
        int n = this.nestCapacities.get(iShape);
        this.nestCapacities.put(iShape, n - 1);
        return n <= 1;
    }

    public Map<IShape, Integer> getNestCapacities() {
        return this.nestCapacities;
    }

    protected Map<IShape, Integer> computeMaxPerNest(IList<IShape> iList, String string) {
        return iList.stream().collect(Collectors.toMap(iShape -> iShape, iShape -> Cast.asInt((IScope)GAMA.getRuntimeScope(), (Object)iShape.getAttribute(string))));
    }

    protected Map<IShape, Integer> computeMaxPerNest(IList<IShape> iList, Double d) {
        return iList.stream().collect(Collectors.toMap(iShape -> iShape, iShape -> (int)Math.round(d)));
    }
}

