/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.distribution.function;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import spll.localizer.distribution.function.ISpatialComplexFunction;

public class GravityFunction
implements ISpatialComplexFunction<Double> {
    private Map<IShape, Double> mass;
    private double buffer = -1.0;
    private double frictionCoeff = 1.0;
    private BiFunction<Double, Double, Double> function = new BiFunction<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return d / Math.pow(d2, GravityFunction.this.frictionCoeff);
        }
    };

    private GravityFunction() {
    }

    public GravityFunction(IList<? extends IShape> iList, double d, IList<IAgent> iList2) {
        this();
        this.frictionCoeff = d;
        this.mass = iList.stream().collect(Collectors.toMap(Function.identity(), iShape -> iList2.stream().mapToDouble(iAgent -> iShape.euclidianDistanceTo(iAgent.getLocation())).sum()));
    }

    public GravityFunction(IScope iScope, IList<? extends IShape> iList, double d, double d2, IList<IAgent> iList2) {
        this();
        IList iList3 = GamaListFactory.createWithoutCasting((IType)Types.AGENT, iList2);
        this.mass = iList.stream().collect(Collectors.toMap(Function.identity(), iShape -> SpatialQueries.overlapping((IScope)iScope, (IContainer)iList3, (IShape)SpatialTransformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)d2)).length(iScope)));
        this.buffer = d2;
        this.frictionCoeff = d;
    }

    public void setMassDistanceFunction(BiFunction<Double, Double, Double> biFunction) {
        this.function = biFunction;
    }

    public void setSpatialEntityMass(Map<? extends IShape, Double> map) {
        this.mass.putAll(map);
    }

    @Override
    public Double apply(IAgent iAgent, IShape iShape) {
        return this.function.apply(this.mass.get(iShape), iShape.euclidianDistanceTo(iAgent.getLocation()));
    }

    @Override
    public void updateFunctionState(IScope iScope, IList<IAgent> iList, IList<IShape> iList2) {
        if (this.buffer <= 0.0) {
            for (IShape iShape : iList2) {
                this.mass.put(iShape, iList.stream().mapToDouble(iAgent -> iShape.euclidianDistanceTo(iAgent.getLocation())).sum());
            }
        } else {
            for (IShape iShape : iList2) {
                this.mass.put(iShape, Double.valueOf(SpatialQueries.overlapping((IScope)iScope, iList, (IShape)SpatialTransformations.enlarged_by((IScope)iScope, (IShape)iShape.getLocation(), (Double)this.buffer)).length(iScope)));
            }
        }
    }

    @Override
    public void clear() {
        this.mass.clear();
    }
}

