/*
 * Decompiled with CFR 0.152.
 */
package spll.util;

import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.precision.EnhancedPrecisionOp;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.util.AssertionFailedException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpllUtil {
    public static String getStringMatrix(float[][] fArray) {
        Object object = "";
        int n = 0;
        while (n < fArray.length) {
            int n2 = 0;
            while (n2 < fArray[n].length) {
                object = (String)object + "[" + fArray[n][n2] + "]";
                ++n2;
            }
            object = (String)object + "\n";
            ++n;
        }
        return object;
    }

    public static Geometry difference(Geometry geometry, Geometry geometry2) {
        try {
            return geometry.difference(geometry2);
        }
        catch (TopologyException | AssertionFailedException throwable) {
            try {
                PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
                return GeometryPrecisionReducer.reducePointwise((Geometry)geometry, (PrecisionModel)precisionModel).difference(GeometryPrecisionReducer.reducePointwise((Geometry)geometry2, (PrecisionModel)precisionModel));
            }
            catch (RuntimeException runtimeException) {
                try {
                    return geometry.buffer(0.0, 10, 2).difference(geometry2.buffer(0.0, 10, 2));
                }
                catch (TopologyException topologyException) {
                    try {
                        PrecisionModel precisionModel = new PrecisionModel(100000.0);
                        return GeometryPrecisionReducer.reduce((Geometry)geometry, (PrecisionModel)precisionModel).difference(GeometryPrecisionReducer.reduce((Geometry)geometry2, (PrecisionModel)precisionModel));
                    }
                    catch (RuntimeException runtimeException2) {
                        try {
                            return EnhancedPrecisionOp.difference((Geometry)geometry, (Geometry)geometry2);
                        }
                        catch (RuntimeException runtimeException3) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    public static CoordinateReferenceSystem getCRSfromWKT(String string) {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        try {
            coordinateReferenceSystem = CRS.parseWKT((String)string);
        }
        catch (FactoryException factoryException) {
            factoryException.printStackTrace();
        }
        return coordinateReferenceSystem;
    }
}

