/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AttributeImpl;
import io.jhdf.FractalHeap;
import io.jhdf.HdfFile;
import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.btree.BTreeV2;
import io.jhdf.btree.record.AttributeNameForIndexedAttributesRecord;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.Message;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode
implements Node {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNode.class);
    private final HdfFileChannel hdfFc;
    protected final long address;
    protected final String name;
    protected final Group parent;
    protected final LazyInitializer<ObjectHeader> header;
    protected final AttributesLazyInitializer attributes;

    public AbstractNode(HdfFileChannel hdfFileChannel, long l, String string, Group group) {
        this.hdfFc = hdfFileChannel;
        this.address = l;
        this.name = string;
        this.parent = group;
        try {
            this.header = ObjectHeader.lazyReadObjectHeader(hdfFileChannel, l);
            this.attributes = new AttributesLazyInitializer(this.header);
        }
        catch (Exception exception) {
            throw new HdfException("Error reading node '" + this.getPath() + "' at address " + l, exception);
        }
    }

    @Override
    public boolean isGroup() {
        return this.getType() == NodeType.GROUP;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + this.name;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public HdfFile getHdfFile() {
        return this.getParent().getHdfFile();
    }

    @Override
    public boolean isLink() {
        return false;
    }

    protected <T extends Message> T getHeaderMessage(Class<T> clazz) {
        return this.getHeader().getMessageOfType(clazz);
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        try {
            return (Map)this.attributes.get();
        }
        catch (Exception exception) {
            throw new HdfException("Failed to load attributes for '" + this.getPath() + "' at address '" + this.getAddress() + "'", exception);
        }
    }

    @Override
    public Attribute getAttribute(String string) {
        return this.getAttributes().get(string);
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.getHeader().isAttributeCreationOrderTracked();
    }

    public ObjectHeader getHeader() {
        try {
            return (ObjectHeader)this.header.get();
        }
        catch (Exception exception) {
            throw new HdfException("Failed reading header for '" + this.getPath() + "' at address '" + this.getAddress() + "'", exception);
        }
    }

    static /* synthetic */ HdfFileChannel access$0(AbstractNode abstractNode) {
        return abstractNode.hdfFc;
    }

    protected final class AttributesLazyInitializer
    extends LazyInitializer<Map<String, Attribute>> {
        private final LazyInitializer<ObjectHeader> lazyObjectHeader;

        public AttributesLazyInitializer(LazyInitializer<ObjectHeader> lazyInitializer) {
            this.lazyObjectHeader = lazyInitializer;
        }

        protected Map<String, Attribute> initialize() throws ConcurrentException {
            AttributeInfoMessage attributeInfoMessage;
            logger.debug("Lazy initializing attributes for '{}'", (Object)AbstractNode.this.getPath());
            ObjectHeader objectHeader = (ObjectHeader)this.lazyObjectHeader.get();
            ArrayList<AttributeMessage> arrayList = new ArrayList<AttributeMessage>();
            if (objectHeader.hasMessageOfType(AttributeInfoMessage.class) && (attributeInfoMessage = objectHeader.getMessageOfType(AttributeInfoMessage.class)).getFractalHeapAddress() != -1L) {
                FractalHeap fractalHeap = new FractalHeap(AbstractNode.this.hdfFc, attributeInfoMessage.getFractalHeapAddress());
                BTreeV2 bTreeV2 = new BTreeV2(AbstractNode.this.hdfFc, attributeInfoMessage.getAttributeNameBTreeAddress());
                for (AttributeNameForIndexedAttributesRecord attributeNameForIndexedAttributesRecord : bTreeV2.getRecords()) {
                    ByteBuffer byteBuffer = fractalHeap.getId(attributeNameForIndexedAttributesRecord.getHeapId());
                    AttributeMessage attributeMessage2 = new AttributeMessage(byteBuffer, AbstractNode.this.hdfFc.getSuperblock(), attributeNameForIndexedAttributesRecord.getFlags());
                    logger.trace("Read attribute message '{}'", (Object)attributeMessage2);
                    arrayList.add(attributeMessage2);
                }
            }
            arrayList.addAll(objectHeader.getMessagesOfType(AttributeMessage.class));
            return arrayList.stream().collect(Collectors.toMap(AttributeMessage::getName, attributeMessage -> new AttributeImpl(AbstractNode.this.hdfFc, AbstractNode.this, (AttributeMessage)attributeMessage)));
        }
    }
}

