/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GlobalHeap {
    private static final byte[] GLOBAL_HEAP_SIGNATURE = "GCOL".getBytes();
    private final HdfFileChannel hdfFc;
    private final long address;
    private final Map<Integer, GlobalHeapObject> objects = new HashMap<Integer, GlobalHeapObject>();

    public GlobalHeap(HdfFileChannel hdfFileChannel, long l) {
        this.hdfFc = hdfFileChannel;
        this.address = l;
        try {
            int n = 8 + hdfFileChannel.getSizeOfLengths();
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(GLOBAL_HEAP_SIGNATURE, byArray)) {
                throw new HdfException("Global heap signature 'GCOL' not matched, at address " + l);
            }
            byte by = byteBuffer.get();
            if (by != 1) {
                throw new HdfException("Unsupported global heap version detected. Version: " + by);
            }
            byteBuffer.position(8);
            int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
            int n3 = n2 - 8 - hdfFileChannel.getSizeOfLengths();
            byteBuffer = hdfFileChannel.readBufferFromAddress(l + (long)n, n3);
            while (byteBuffer.remaining() >= 16) {
                GlobalHeapObject globalHeapObject = new GlobalHeapObject(byteBuffer);
                if (globalHeapObject.index != 0) {
                    this.objects.put(globalHeapObject.index, globalHeapObject);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new HdfException("Error reading global heap at address " + l, exception);
        }
    }

    public String toString() {
        return "GlobalHeap [address=" + this.address + ", objects=" + this.objects.size() + "]";
    }

    public ByteBuffer getObjectData(int n) {
        if (!this.objects.containsKey(n)) {
            throw new IllegalArgumentException("Global heap doesn't contain object with index: " + n);
        }
        return this.objects.get((Object)Integer.valueOf((int)n)).data.slice();
    }

    public int getObjectReferenceCount(int n) {
        if (!this.objects.containsKey(n)) {
            throw new IllegalArgumentException("Global heap doesn't contain object with index: " + n);
        }
        return this.objects.get((Object)Integer.valueOf((int)n)).referenceCount;
    }

    private class GlobalHeapObject {
        final int index;
        final int referenceCount;
        final ByteBuffer data;

        private GlobalHeapObject(ByteBuffer byteBuffer) {
            this.index = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.referenceCount = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            byteBuffer.position(byteBuffer.position() + 4);
            int n = Utils.readBytesAsUnsignedInt(byteBuffer, GlobalHeap.this.hdfFc.getSizeOfOffsets());
            if (this.index == 0) {
                n = n - 2 - 2 - 4 - GlobalHeap.this.hdfFc.getSizeOfOffsets();
            }
            this.data = Utils.createSubBuffer(byteBuffer, n);
            Utils.seekBufferToNextMultipleOfEight(byteBuffer);
        }
    }
}

