/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.SymbolTableEntry;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupSymbolTableNode {
    private static final Logger logger = LoggerFactory.getLogger(GroupSymbolTableNode.class);
    private static final byte[] NODE_SIGNATURE = "SNOD".getBytes();
    private final long address;
    private final short version;
    private final short numberOfEntries;
    private final SymbolTableEntry[] symbolTableEntries;

    public GroupSymbolTableNode(HdfFileChannel hdfFileChannel, long l) {
        this.address = l;
        try {
            int n = 8;
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(NODE_SIGNATURE, byArray)) {
                throw new HdfException("Group symbol table Node signature not matched");
            }
            this.version = byteBuffer.get();
            byteBuffer.position(6);
            byte[] byArray2 = new byte[2];
            byteBuffer.get(byArray2);
            this.numberOfEntries = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getShort();
            logger.trace("numberOfSymbols = {}", (Object)this.numberOfEntries);
            int n2 = hdfFileChannel.getSizeOfOffsets() * 2 + 8 + 16;
            this.symbolTableEntries = new SymbolTableEntry[this.numberOfEntries];
            int n3 = 0;
            while (n3 < this.numberOfEntries) {
                long l2 = l + (long)n + (long)(n3 * n2);
                this.symbolTableEntries[n3] = new SymbolTableEntry(hdfFileChannel, l2);
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new HdfException("Error reading Group symbol table node", exception);
        }
    }

    public short getVersion() {
        return this.version;
    }

    public short getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public SymbolTableEntry[] getSymbolTableEntries() {
        return this.symbolTableEntries;
    }

    public String toString() {
        return "GroupSymbolTableNode [address=" + this.address + ", numberOfEntries=" + this.numberOfEntries + "]";
    }
}

