/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.GroupImpl;
import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.SymbolTableEntry;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.exceptions.HdfException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfFile
implements Group,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HdfFile.class);
    private final File file;
    private final HdfFileChannel hdfFc;
    private final Group rootGroup;
    private final Set<HdfFile> openExternalFiles;

    static {
        String string = HdfFile.class.getPackage().getImplementationVersion();
        if (string != null) {
            logger.info("jHDF version: {}", (Object)HdfFile.class.getPackage().getImplementationVersion());
        } else {
            logger.warn("Using development version of jHDF");
        }
    }

    public HdfFile(File file) {
        block8: {
            this.openExternalFiles = new HashSet<HdfFile>();
            logger.info("Opening HDF5 file '{}'...", (Object)file.getAbsolutePath());
            this.file = file;
            try {
                FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
                boolean bl = false;
                long l = 0L;
                while (l < fileChannel.size()) {
                    logger.trace("Checking for signature at offset = {}", (Object)l);
                    bl = Superblock.verifySignature(fileChannel, l);
                    if (bl) {
                        logger.debug("Found valid signature at offset = {}", (Object)l);
                        break;
                    }
                    l = this.nextOffset(l);
                }
                if (!bl) {
                    throw new HdfException("No valid HDF5 signature found");
                }
                Superblock superblock = Superblock.readSuperblock(fileChannel, l);
                if (superblock.getBaseAddressByte() != l) {
                    throw new HdfException("Invalid superblock base address detected");
                }
                this.hdfFc = new HdfFileChannel(fileChannel, superblock);
                if (superblock instanceof Superblock.SuperblockV0V1) {
                    Superblock.SuperblockV0V1 superblockV0V1 = (Superblock.SuperblockV0V1)superblock;
                    SymbolTableEntry symbolTableEntry = new SymbolTableEntry(this.hdfFc, superblockV0V1.getRootGroupSymbolTableAddress() - superblockV0V1.getBaseAddressByte());
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfFc, symbolTableEntry.getObjectHeaderAddress(), this);
                    break block8;
                }
                if (superblock instanceof Superblock.SuperblockV2V3) {
                    Superblock.SuperblockV2V3 superblockV2V3 = (Superblock.SuperblockV2V3)superblock;
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfFc, superblockV2V3.getRootGroupObjectHeaderAddress(), this);
                    break block8;
                }
                throw new HdfException("Unrecognized superblock version = " + superblock.getVersionOfSuperblock());
            }
            catch (IOException iOException) {
                throw new HdfException("Failed to open file '" + this.file.getAbsolutePath() + "' . Is it a HDF5 file?", iOException);
            }
        }
        logger.info("Opened HDF5 file '{}'", (Object)file.getAbsolutePath());
    }

    private long nextOffset(long l) {
        if (l == 0L) {
            return 512L;
        }
        return l * 2L;
    }

    public long getUserBlockSize() {
        return this.hdfFc.getUserBlockSize();
    }

    public ByteBuffer getUserBlockBuffer() {
        return this.hdfFc.mapNoOffset(0L, this.hdfFc.getUserBlockSize());
    }

    @Override
    public void close() {
        for (HdfFile hdfFile : this.openExternalFiles) {
            hdfFile.close();
            logger.info("Closed external file '{}'", (Object)hdfFile.getFile().getAbsolutePath());
        }
        this.hdfFc.close();
        logger.info("Closed HDF file '{}'", (Object)this.getFile().getAbsolutePath());
    }

    public long size() {
        return this.hdfFc.size();
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Map<String, Node> getChildren() {
        return this.rootGroup.getChildren();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return "/";
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.rootGroup.getAttributes();
    }

    @Override
    public Attribute getAttribute(String string) {
        return this.rootGroup.getAttribute(string);
    }

    public String toString() {
        return "HdfFile [file=" + this.file.getName() + "]";
    }

    @Override
    public NodeType getType() {
        return NodeType.FILE;
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getAddress() {
        return this.rootGroup.getAddress();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.rootGroup.iterator();
    }

    @Override
    public Node getChild(String string) {
        return this.rootGroup.getChild(string);
    }

    @Override
    public Node getByPath(String string) {
        string = StringUtils.stripStart((String)string, (String)"/");
        return this.rootGroup.getByPath(string);
    }

    @Override
    public Dataset getDatasetByPath(String string) {
        string = StringUtils.stripStart((String)string, (String)"/");
        return this.rootGroup.getDatasetByPath(string);
    }

    @Override
    public HdfFile getHdfFile() {
        return this;
    }

    public void addExternalFile(HdfFile hdfFile) {
        this.openExternalFiles.add(hdfFile);
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.rootGroup.isAttributeCreationOrderTracked();
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        return this.rootGroup.isLinkCreationOrderTracked();
    }

    public HdfFileChannel getHdfChannel() {
        return this.hdfFc;
    }
}

