/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import io.jhdf.object.message.ObjectHeaderContinuationMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectHeader {
    private static final Logger logger = LoggerFactory.getLogger(ObjectHeader.class);
    private final long address;
    protected final List<Message> messages = new ArrayList<Message>();

    public long getAddress() {
        return this.address;
    }

    public abstract int getVersion();

    public abstract boolean isAttributeCreationOrderTracked();

    public abstract boolean isAttributeCreationOrderIndexed();

    public List<Message> getMessages() {
        return this.messages;
    }

    public ObjectHeader(long l) {
        this.address = l;
    }

    public <T extends Message> List<T> getMessagesOfType(Class<T> clazz) {
        return this.getMessages().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public <T extends Message> boolean hasMessageOfType(Class<T> clazz) {
        return !this.getMessagesOfType(clazz).isEmpty();
    }

    public <T extends Message> T getMessageOfType(Class<T> clazz) {
        List<T> list = this.getMessagesOfType(clazz);
        if (list.isEmpty()) {
            throw new HdfException("Requested message type '" + clazz.getSimpleName() + "' not present");
        }
        if (list.size() > 1) {
            throw new HdfException("Requested message type '" + clazz.getSimpleName() + "' is not unique");
        }
        return (T)((Message)list.get(0));
    }

    public static ObjectHeader readObjectHeader(HdfFileChannel hdfFileChannel, long l) {
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, 1);
        byte by = byteBuffer.get();
        if (by == 1) {
            return new ObjectHeaderV1(hdfFileChannel, l);
        }
        return new ObjectHeaderV2(hdfFileChannel, l);
    }

    public static LazyInitializer<ObjectHeader> lazyReadObjectHeader(final HdfFileChannel hdfFileChannel, final long l) {
        logger.debug("Creating lazy object header at address: {}", (Object)l);
        return new LazyInitializer<ObjectHeader>(){

            protected ObjectHeader initialize() {
                logger.debug("Lazy initializing object header at address: {}", (Object)l);
                return ObjectHeader.readObjectHeader(hdfFileChannel, l);
            }
        };
    }

    public static class ObjectHeaderV1
    extends ObjectHeader {
        private final byte version;
        private final int referenceCount;

        private ObjectHeaderV1(HdfFileChannel hdfFileChannel, long l) {
            super(l);
            try {
                ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, 12);
                this.version = byteBuffer.get();
                if (this.version != 1) {
                    throw new HdfException("Invalid version detected. Version is = " + this.version);
                }
                byteBuffer.position(byteBuffer.position() + 1);
                int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
                this.referenceCount = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                byteBuffer = hdfFileChannel.readBufferFromAddress(l += 16L, n2);
                this.readMessages(hdfFileChannel, byteBuffer, n);
                logger.debug("Read object header from address: {}", (Object)l);
            }
            catch (Exception exception) {
                throw new HdfException("Failed to read object header at address: " + l, exception);
            }
        }

        private void readMessages(HdfFileChannel hdfFileChannel, ByteBuffer byteBuffer, int n) {
            while (byteBuffer.remaining() > 4 && this.messages.size() < n) {
                Message message = Message.readObjectHeaderV1Message(byteBuffer, hdfFileChannel.getSuperblock());
                this.messages.add(message);
                if (!(message instanceof ObjectHeaderContinuationMessage)) continue;
                ObjectHeaderContinuationMessage objectHeaderContinuationMessage = (ObjectHeaderContinuationMessage)message;
                ByteBuffer byteBuffer2 = hdfFileChannel.readBufferFromAddress(objectHeaderContinuationMessage.getOffset(), objectHeaderContinuationMessage.getLength());
                this.readMessages(hdfFileChannel, byteBuffer2, n);
            }
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        @Override
        public boolean isAttributeCreationOrderTracked() {
            return false;
        }

        @Override
        public boolean isAttributeCreationOrderIndexed() {
            return false;
        }
    }

    public static class ObjectHeaderV2
    extends ObjectHeader {
        private static final byte[] OBJECT_HEADER_V2_SIGNATURE = "OHDR".getBytes();
        private static final byte[] OBJECT_HEADER_V2_CONTINUATION_SIGNATURE = "OCHK".getBytes();
        private static final int ATTRIBUTE_CREATION_ORDER_TRACKED = 2;
        private static final int ATTRIBUTE_CREATION_ORDER_INDEXED = 3;
        private static final int NUMBER_OF_ATTRIBUTES_PRESENT = 4;
        private static final int TIMESTAMPS_PRESENT = 5;
        private final byte version;
        private final long accessTime;
        private final long modificationTime;
        private final long changeTime;
        private final long birthTime;
        private final int maximumNumberOfCompactAttributes;
        private final int maximumNumberOfDenseAttributes;
        private final BitSet flags;

        private ObjectHeaderV2(HdfFileChannel hdfFileChannel, long l) {
            super(l);
            try {
                ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, 6);
                l += 6L;
                byte[] byArray = new byte[OBJECT_HEADER_V2_SIGNATURE.length];
                byteBuffer.get(byArray);
                if (!Arrays.equals(OBJECT_HEADER_V2_SIGNATURE, byArray)) {
                    throw new HdfException("Object header v2 signature not matched");
                }
                this.version = byteBuffer.get();
                if (this.version != 2) {
                    throw new HdfException("Invalid version detected. Version is = " + this.version);
                }
                this.flags = BitSet.valueOf(new byte[]{byteBuffer.get()});
                int n = this.flags.get(1) ? (this.flags.get(0) ? 8 : 4) : (this.flags.get(0) ? 2 : 1);
                if (this.flags.get(5)) {
                    byteBuffer = hdfFileChannel.readBufferFromAddress(l, 16);
                    l += 16L;
                    this.accessTime = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
                    this.modificationTime = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
                    this.changeTime = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
                    this.birthTime = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
                } else {
                    this.accessTime = -1L;
                    this.modificationTime = -1L;
                    this.changeTime = -1L;
                    this.birthTime = -1L;
                }
                if (this.flags.get(4)) {
                    byteBuffer = hdfFileChannel.readBufferFromAddress(l, 4);
                    l += 4L;
                    this.maximumNumberOfCompactAttributes = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
                    this.maximumNumberOfDenseAttributes = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
                } else {
                    this.maximumNumberOfCompactAttributes = -1;
                    this.maximumNumberOfDenseAttributes = -1;
                }
                byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
                int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, n);
                byteBuffer = hdfFileChannel.readBufferFromAddress(l += (long)n, n2);
                this.readMessages(hdfFileChannel, byteBuffer);
                logger.debug("Read object header from address: {}", (Object)l);
            }
            catch (Exception exception) {
                throw new HdfException("Failed to read object header at address: " + l, exception);
            }
        }

        private void readMessages(HdfFileChannel hdfFileChannel, ByteBuffer byteBuffer) {
            while (byteBuffer.remaining() >= 8) {
                Message message = Message.readObjectHeaderV2Message(byteBuffer, hdfFileChannel.getSuperblock(), this.isAttributeCreationOrderTracked());
                this.messages.add(message);
                if (!(message instanceof ObjectHeaderContinuationMessage)) continue;
                ObjectHeaderContinuationMessage objectHeaderContinuationMessage = (ObjectHeaderContinuationMessage)message;
                ByteBuffer byteBuffer2 = hdfFileChannel.readBufferFromAddress(objectHeaderContinuationMessage.getOffset(), objectHeaderContinuationMessage.getLength());
                byte[] byArray = new byte[OBJECT_HEADER_V2_CONTINUATION_SIGNATURE.length];
                byteBuffer2.get(byArray);
                if (!Arrays.equals(OBJECT_HEADER_V2_CONTINUATION_SIGNATURE, byArray)) {
                    throw new HdfException("Object header continuation header not matched, at address: " + objectHeaderContinuationMessage.getOffset());
                }
                this.readMessages(hdfFileChannel, byteBuffer2);
            }
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public long getAccessTime() {
            return this.accessTime;
        }

        public long getModificationTime() {
            return this.modificationTime;
        }

        public long getChangeTime() {
            return this.changeTime;
        }

        public long getBirthTime() {
            return this.birthTime;
        }

        public int getMaximumNumberOfCompactAttributes() {
            return this.maximumNumberOfCompactAttributes;
        }

        public int getMaximumNumberOfDenseAttributes() {
            return this.maximumNumberOfDenseAttributes;
        }

        @Override
        public boolean isAttributeCreationOrderTracked() {
            return this.flags.get(2);
        }

        @Override
        public boolean isAttributeCreationOrderIndexed() {
            return this.flags.get(3);
        }
    }
}

