/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Superblock {
    private static final Logger logger = LoggerFactory.getLogger(Superblock.class);
    private static final byte[] HDF5_FILE_SIGNATURE = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
    private static final int HDF5_FILE_SIGNATURE_LENGTH = HDF5_FILE_SIGNATURE.length;

    public abstract int getVersionOfSuperblock();

    public abstract int getSizeOfOffsets();

    public abstract int getSizeOfLengths();

    public abstract long getBaseAddressByte();

    public abstract long getEndOfFileAddress();

    static boolean verifySignature(FileChannel fileChannel, long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(HDF5_FILE_SIGNATURE_LENGTH);
        try {
            fileChannel.read(byteBuffer, l);
        }
        catch (IOException iOException) {
            throw new HdfException("Failed to read from address: " + Utils.toHex(l), iOException);
        }
        return Arrays.equals(HDF5_FILE_SIGNATURE, byteBuffer.array());
    }

    public static Superblock readSuperblock(FileChannel fileChannel, long l) {
        boolean bl = Superblock.verifySignature(fileChannel, l);
        if (!bl) {
            throw new HdfException("Superblock didn't contain valid signature");
        }
        logger.trace("Verified superblock signature");
        long l2 = l + (long)HDF5_FILE_SIGNATURE_LENGTH;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        try {
            fileChannel.read(byteBuffer, l2);
        }
        catch (IOException iOException) {
            throw new HdfException("Failed to read superblock at address = " + Utils.toHex(l));
        }
        byteBuffer.rewind();
        byte by = byteBuffer.get();
        logger.debug("Version of superblock is = {}", (Object)by);
        switch (by) {
            case 0: 
            case 1: {
                return new SuperblockV0V1(fileChannel, l2);
            }
            case 2: 
            case 3: {
                return new SuperblockV2V3(fileChannel, l2);
            }
        }
        throw new UnsupportedHdfException("Superblock version is not supported. Detected version = " + by);
    }

    public static class SuperblockV0V1
    extends Superblock {
        private final int versionOfSuperblock;
        private final int versionNumberOfTheFileFreeSpaceInformation;
        private final int versionOfRootGroupSymbolTableEntry;
        private final int versionOfSharedHeaderMessageFormat;
        private final int sizeOfOffsets;
        private final int sizeOfLengths;
        private final int groupLeafNodeK;
        private final int groupInternalNodeK;
        private final long baseAddressByte;
        private final long addressOfGlobalFreeSpaceIndex;
        private final long endOfFileAddress;
        private final long driverInformationBlockAddress;
        private final long rootGroupSymbolTableAddress;

        private SuperblockV0V1(FileChannel fileChannel, long l) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(12);
                fileChannel.read(byteBuffer, l);
                l += 12L;
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.rewind();
                this.versionOfSuperblock = byteBuffer.get();
                logger.trace("Version of superblock is = {}", (Object)this.versionOfSuperblock);
                if (this.versionOfSuperblock != 0 && this.versionOfSuperblock != 1) {
                    throw new HdfException("Detected superblock version not 0 or 1");
                }
                this.versionNumberOfTheFileFreeSpaceInformation = byteBuffer.get();
                logger.trace("Version Number of the File Free-Space Information: {}", (Object)this.versionNumberOfTheFileFreeSpaceInformation);
                this.versionOfRootGroupSymbolTableEntry = byteBuffer.get();
                logger.trace("Version # of Root Group Symbol Table Entry: {}", (Object)this.versionOfRootGroupSymbolTableEntry);
                byteBuffer.position(byteBuffer.position() + 1);
                this.versionOfSharedHeaderMessageFormat = byteBuffer.get();
                logger.trace("Version # of Shared Header Message Format: {}", (Object)this.versionOfSharedHeaderMessageFormat);
                this.sizeOfOffsets = Byte.toUnsignedInt(byteBuffer.get());
                logger.trace("Size of Offsets: {}", (Object)this.sizeOfOffsets);
                this.sizeOfLengths = Byte.toUnsignedInt(byteBuffer.get());
                logger.trace("Size of Lengths: {}", (Object)this.sizeOfLengths);
                byteBuffer.position(byteBuffer.position() + 1);
                this.groupLeafNodeK = Short.toUnsignedInt(byteBuffer.getShort());
                logger.trace("groupLeafNodeK = {}", (Object)this.groupLeafNodeK);
                this.groupInternalNodeK = Short.toUnsignedInt(byteBuffer.getShort());
                logger.trace("groupInternalNodeK = {}", (Object)this.groupInternalNodeK);
                l += 4L;
                if (this.versionOfSuperblock == 1) {
                    l += 4L;
                }
                int n = 4 * this.sizeOfOffsets;
                byteBuffer = ByteBuffer.allocate(n);
                fileChannel.read(byteBuffer, l);
                l += (long)n;
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.rewind();
                this.baseAddressByte = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("baseAddressByte = {}", (Object)this.baseAddressByte);
                this.addressOfGlobalFreeSpaceIndex = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("addressOfGlobalFreeSpaceIndex = {}", (Object)this.addressOfGlobalFreeSpaceIndex);
                this.endOfFileAddress = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("endOfFileAddress = {}", (Object)this.endOfFileAddress);
                this.driverInformationBlockAddress = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("driverInformationBlockAddress = {}", (Object)this.driverInformationBlockAddress);
                this.rootGroupSymbolTableAddress = l;
                logger.trace("rootGroupSymbolTableAddress= {}", (Object)this.rootGroupSymbolTableAddress);
            }
            catch (Exception exception) {
                throw new HdfException("Failed to read superblock from address " + Utils.toHex(l), exception);
            }
        }

        @Override
        public int getVersionOfSuperblock() {
            return this.versionOfSuperblock;
        }

        public int getVersionNumberOfTheFileFreeSpaceInformation() {
            return this.versionNumberOfTheFileFreeSpaceInformation;
        }

        public int getVersionOfRootGroupSymbolTableEntry() {
            return this.versionOfRootGroupSymbolTableEntry;
        }

        public int getVersionOfSharedHeaderMessageFormat() {
            return this.versionOfSharedHeaderMessageFormat;
        }

        @Override
        public int getSizeOfOffsets() {
            return this.sizeOfOffsets;
        }

        @Override
        public int getSizeOfLengths() {
            return this.sizeOfLengths;
        }

        public int getGroupLeafNodeK() {
            return this.groupLeafNodeK;
        }

        public int getGroupInternalNodeK() {
            return this.groupInternalNodeK;
        }

        @Override
        public long getBaseAddressByte() {
            return this.baseAddressByte;
        }

        public long getAddressOfGlobalFreeSpaceIndex() {
            return this.addressOfGlobalFreeSpaceIndex;
        }

        @Override
        public long getEndOfFileAddress() {
            return this.endOfFileAddress;
        }

        public long getDriverInformationBlockAddress() {
            return this.driverInformationBlockAddress;
        }

        public long getRootGroupSymbolTableAddress() {
            return this.rootGroupSymbolTableAddress;
        }
    }

    public static class SuperblockV2V3
    extends Superblock {
        private final int versionOfSuperblock;
        private final int sizeOfOffsets;
        private final int sizeOfLengths;
        private final long baseAddressByte;
        private final long superblockExtensionAddress;
        private final long endOfFileAddress;
        private final long rootGroupObjectHeaderAddress;

        private SuperblockV2V3(FileChannel fileChannel, long l) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                fileChannel.read(byteBuffer, l);
                l += 4L;
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.rewind();
                this.versionOfSuperblock = byteBuffer.get();
                logger.trace("Version of superblock is = {}", (Object)this.versionOfSuperblock);
                this.sizeOfOffsets = Byte.toUnsignedInt(byteBuffer.get());
                logger.trace("Size of Offsets: {}", (Object)this.sizeOfOffsets);
                this.sizeOfLengths = Byte.toUnsignedInt(byteBuffer.get());
                logger.trace("Size of Lengths: {}", (Object)this.sizeOfLengths);
                int n = 4 * this.sizeOfOffsets + 4;
                byteBuffer = ByteBuffer.allocate(n);
                fileChannel.read(byteBuffer, l);
                l += (long)n;
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.rewind();
                this.baseAddressByte = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("baseAddressByte = {}", (Object)this.baseAddressByte);
                this.superblockExtensionAddress = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("addressOfGlobalFreeSpaceIndex = {}", (Object)this.superblockExtensionAddress);
                if (this.superblockExtensionAddress != -1L) {
                    throw new UnsupportedHdfException("Superblock extension is not supported");
                }
                this.endOfFileAddress = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("endOfFileAddress = {}", (Object)this.endOfFileAddress);
                this.rootGroupObjectHeaderAddress = Utils.readBytesAsUnsignedLong(byteBuffer, this.sizeOfOffsets);
                logger.trace("rootGroupObjectHeaderAddress= {}", (Object)this.rootGroupObjectHeaderAddress);
            }
            catch (Exception exception) {
                throw new HdfException("Failed to read superblock from address " + Utils.toHex(l), exception);
            }
        }

        @Override
        public int getVersionOfSuperblock() {
            return this.versionOfSuperblock;
        }

        @Override
        public int getSizeOfOffsets() {
            return this.sizeOfOffsets;
        }

        @Override
        public int getSizeOfLengths() {
            return this.sizeOfLengths;
        }

        @Override
        public long getBaseAddressByte() {
            return this.baseAddressByte;
        }

        public long getSuperblockExtensionAddress() {
            return this.superblockExtensionAddress;
        }

        @Override
        public long getEndOfFileAddress() {
            return this.endOfFileAddress;
        }

        public long getRootGroupObjectHeaderAddress() {
            return this.rootGroupObjectHeaderAddress;
        }
    }
}

