/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1Data;
import io.jhdf.btree.BTreeV1Group;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BTreeV1 {
    private static final Logger logger = LoggerFactory.getLogger(BTreeV1.class);
    private static final byte[] BTREE_NODE_V1_SIGNATURE = "TREE".getBytes();
    private static final int HEADER_BYTES = 6;
    private final long address;
    protected final int entriesUsed;
    private final long leftSiblingAddress;
    private final long rightSiblingAddress;

    public static BTreeV1Group createGroupBTree(HdfFileChannel hdfFileChannel, long l) {
        ByteBuffer byteBuffer = BTreeV1.readHeaderAndValidateSignature(hdfFileChannel, l);
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new HdfException("B tree type is not group. Type is: " + by);
        }
        byte by2 = byteBuffer.get();
        if (by2 > 0) {
            return new BTreeV1Group.BTreeV1GroupNonLeafNode(hdfFileChannel, l);
        }
        return new BTreeV1Group.BTreeV1GroupLeafNode(hdfFileChannel, l);
    }

    public static BTreeV1Data createDataBTree(HdfFileChannel hdfFileChannel, long l, int n) {
        ByteBuffer byteBuffer = BTreeV1.readHeaderAndValidateSignature(hdfFileChannel, l);
        byte by = byteBuffer.get();
        if (by != 1) {
            throw new HdfException("B tree type is not data. Type is: " + by);
        }
        byte by2 = byteBuffer.get();
        if (by2 > 0) {
            return new BTreeV1Data.BTreeV1DataNonLeafNode(hdfFileChannel, l, n);
        }
        return new BTreeV1Data.BTreeV1DataLeafNode(hdfFileChannel, l, n);
    }

    public static ByteBuffer readHeaderAndValidateSignature(HdfFileChannel hdfFileChannel, long l) {
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, 6);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray, 0, byArray.length);
        if (!Arrays.equals(BTREE_NODE_V1_SIGNATURE, byArray)) {
            throw new HdfException("B tree V1 node signature not matched");
        }
        return byteBuffer;
    }

    BTreeV1(HdfFileChannel hdfFileChannel, long l) {
        this.address = l;
        int n = 8 * hdfFileChannel.getSizeOfOffsets();
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l + 6L, n);
        this.entriesUsed = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
        logger.trace("Entries = {}", (Object)this.entriesUsed);
        this.leftSiblingAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
        logger.trace("left address = {}", (Object)this.leftSiblingAddress);
        this.rightSiblingAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
        logger.trace("right address = {}", (Object)this.rightSiblingAddress);
    }

    public int getEntriesUsed() {
        return this.entriesUsed;
    }

    public long getLeftSiblingAddress() {
        return this.leftSiblingAddress;
    }

    public long getRightSiblingAddress() {
        return this.rightSiblingAddress;
    }

    public long getAddress() {
        return this.address;
    }

    public abstract List<Long> getChildAddresses();
}

