/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.dataset.DatasetReader;
import io.jhdf.object.datatype.CompoundDataType;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CompoundDatasetReader {
    private CompoundDatasetReader() {
    }

    public static Map<String, Object> readDataset(CompoundDataType compoundDataType, ByteBuffer byteBuffer, long l, int[] nArray) {
        int n = Math.toIntExact(l);
        List<CompoundDataType.CompoundDataMember> list = compoundDataType.getMembers();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(list.size());
        for (CompoundDataType.CompoundDataMember compoundDataMember : list) {
            byte[] byArray = new byte[compoundDataMember.getDataType().getSize()];
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(compoundDataMember.getDataType().getSize() * n);
            int n2 = 0;
            while (n2 < n) {
                byteBuffer.position(compoundDataType.getSize() * n2 + compoundDataMember.getOffset());
                byteBuffer.get(byArray, 0, byArray.length);
                byteBuffer2.put(byArray);
                ++n2;
            }
            byteBuffer2.rewind();
            Object object = DatasetReader.readDataset(compoundDataMember.getDataType(), byteBuffer2, nArray);
            linkedHashMap.put(compoundDataMember.getName(), object);
        }
        return linkedHashMap;
    }
}

