/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;
import java.nio.ByteBuffer;

public class ContiguousDataset
extends DatasetBase {
    public ContiguousDataset(HdfFileChannel hdfFileChannel, long l, String string, Group group, ObjectHeader objectHeader) {
        super(hdfFileChannel, l, string, group, objectHeader);
    }

    @Override
    public ByteBuffer getDataBuffer() {
        DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);
        if (contiguousDataLayoutMessage.getAddress() == -1L) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = this.hdfFc.map(contiguousDataLayoutMessage.getAddress(), contiguousDataLayoutMessage.getSize());
            this.convertToCorrectEndiness(byteBuffer);
            return byteBuffer;
        }
        catch (Exception exception) {
            throw new HdfException("Failed to map data buffer for dataset '" + this.getPath() + "'", exception);
        }
    }

    public long getDataAddress() {
        DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);
        return contiguousDataLayoutMessage.getAddress();
    }
}

