/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.AbstractNode;
import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.NodeType;
import io.jhdf.dataset.CompoundDatasetReader;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.dataset.VariableLengthDatasetReader;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetBase
extends AbstractNode
implements Dataset {
    private static final Logger logger = LoggerFactory.getLogger(DatasetBase.class);
    protected final HdfFileChannel hdfFc;
    protected final ObjectHeader oh;
    private final DataType dataType;
    private final DataSpace dataSpace;

    public DatasetBase(HdfFileChannel hdfFileChannel, long l, String string, Group group, ObjectHeader objectHeader) {
        super(hdfFileChannel, l, string, group);
        this.hdfFc = hdfFileChannel;
        this.oh = objectHeader;
        this.dataType = this.getHeaderMessage(DataTypeMessage.class).getDataType();
        this.dataSpace = this.getHeaderMessage(DataSpaceMessage.class).getDataSpace();
    }

    @Override
    public NodeType getType() {
        return NodeType.DATASET;
    }

    protected void convertToCorrectEndiness(ByteBuffer byteBuffer) {
        if (this.dataType instanceof OrderedDataType) {
            ByteOrder byteOrder = ((OrderedDataType)((Object)this.dataType)).getByteOrder();
            byteBuffer.order(byteOrder);
            if (logger.isTraceEnabled()) {
                logger.trace("Set buffer order of '{}' to {}", (Object)this.getPath(), (Object)byteOrder);
            }
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public long getSize() {
        return this.dataSpace.getTotalLength();
    }

    @Override
    public long getDiskSize() {
        return this.getSize() * (long)this.dataType.getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.dataSpace.getDimensions();
    }

    @Override
    public int[] getMaxSize() {
        if (this.dataSpace.isMaxSizesPresent()) {
            return this.dataSpace.getMaxSizes();
        }
        return this.getDimensions();
    }

    @Override
    public DataLayout getDataLayout() {
        return this.getHeaderMessage(DataLayoutMessage.class).getDataLayout();
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> clazz = this.dataType.getJavaType();
        if (this.isScalar() && clazz.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(clazz);
        }
        return clazz;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getData() {
        logger.debug("Getting data for '{}'...", (Object)this.getPath());
        ByteBuffer byteBuffer = this.getDataBuffer();
        if (byteBuffer == null) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (dataType instanceof VariableLength) {
            return VariableLengthDatasetReader.readDataset((VariableLength)dataType, byteBuffer, this.getDimensions(), this.hdfFc);
        }
        if (dataType instanceof CompoundDataType) {
            return CompoundDatasetReader.readDataset((CompoundDataType)dataType, byteBuffer, this.getSize(), this.getDimensions());
        }
        return DatasetReader.readDataset(dataType, byteBuffer, this.getDimensions());
    }

    @Override
    public boolean isScalar() {
        return this.getDimensions().length == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getDiskSize() == 0L;
    }

    @Override
    public boolean isCompound() {
        return this.getDataType() instanceof CompoundDataType;
    }

    public abstract ByteBuffer getDataBuffer();

    @Override
    public Object getFillValue() {
        FillValueMessage fillValueMessage = this.getHeaderMessage(FillValueMessage.class);
        if (fillValueMessage.isFillValueDefined()) {
            ByteBuffer byteBuffer = fillValueMessage.getFillValue();
            return DatasetReader.readDataset(this.getDataType(), byteBuffer, new int[0]);
        }
        return null;
    }

    public String toString() {
        return "DatasetBase [path=" + this.getPath() + "]";
    }
}

