/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.dataset.CompactDataset;
import io.jhdf.dataset.ContiguousDataset;
import io.jhdf.dataset.chunked.ChunkedDatasetV3;
import io.jhdf.dataset.chunked.ChunkedDatasetV4;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;

public final class DatasetLoader {
    private DatasetLoader() {
    }

    public static Dataset createDataset(HdfFileChannel hdfFileChannel, ObjectHeader objectHeader, String string, Group group) {
        long l = objectHeader.getAddress();
        try {
            DataLayoutMessage dataLayoutMessage = objectHeader.getMessageOfType(DataLayoutMessage.class);
            if (dataLayoutMessage instanceof DataLayoutMessage.CompactDataLayoutMessage) {
                return new CompactDataset(hdfFileChannel, l, string, group, objectHeader);
            }
            if (dataLayoutMessage instanceof DataLayoutMessage.ContiguousDataLayoutMessage) {
                return new ContiguousDataset(hdfFileChannel, l, string, group, objectHeader);
            }
            if (dataLayoutMessage instanceof DataLayoutMessage.ChunkedDataLayoutMessageV3) {
                return new ChunkedDatasetV3(hdfFileChannel, l, string, group, objectHeader);
            }
            if (dataLayoutMessage instanceof DataLayoutMessage.ChunkedDataLayoutMessageV4) {
                return new ChunkedDatasetV4(hdfFileChannel, l, string, group, objectHeader);
            }
            throw new HdfException("Unrecognized Dataset layout type: " + dataLayoutMessage.getClass().getCanonicalName());
        }
        catch (Exception exception) {
            throw new HdfException("Failed to read dataset '" + string + "' at address '" + l + "'", exception);
        }
    }
}

