/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.Utils;
import io.jhdf.api.Group;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.exceptions.HdfException;
import io.jhdf.filter.FilterManager;
import io.jhdf.filter.FilterPipeline;
import io.jhdf.object.message.FilterPipelineMessage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkedDatasetBase
extends DatasetBase {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedDatasetBase.class);
    protected final FilterPipelineLazyInitializer lazyPipeline = new FilterPipelineLazyInitializer();

    public ChunkedDatasetBase(HdfFileChannel hdfFileChannel, long l, String string, Group group, ObjectHeader objectHeader) {
        super(hdfFileChannel, l, string, group, objectHeader);
    }

    protected void fillDataFromChunk(Chunk chunk, byte[] byArray, int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        logger.debug("Filling data from chunk '{}'", (Object)chunk);
        byte[] byArray2 = this.decompressChunk(chunk);
        int[] nArray4 = chunk.getChunkOffset();
        int n3 = Utils.dimensionIndexToLinearIndex(nArray4, this.getDimensions());
        if (!this.isPartialChunk(chunk)) {
            int n4 = n * n2;
            int n5 = 0;
            while (n5 < nArray2.length) {
                System.arraycopy(byArray2, nArray2[n5], byArray, (nArray3[n5] + n3) * n2, n4);
                ++n5;
            }
        } else {
            logger.debug("Handling partial chunk '{}'", (Object)chunk);
            int n6 = this.getDimensions().length - 1;
            int n7 = 0;
            while (n7 < nArray2.length) {
                if (nArray3[n7] <= byArray.length && !this.partOfChunkIsOutsideDataset(nArray2[n7] / n2, nArray, nArray4)) {
                    int n8 = n2 * Math.min(n, n - (nArray4[n6] + nArray[n6] - this.getDimensions()[n6]));
                    System.arraycopy(byArray2, nArray2[n7], byArray, (nArray3[n7] + n3) * n2, n8);
                }
                ++n7;
            }
        }
    }

    private boolean partOfChunkIsOutsideDataset(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = Utils.linearIndexToDimensionIndex(n, nArray);
        int n2 = 0;
        while (n2 < nArray3.length - 1) {
            if (nArray2[n2] + nArray3[n2] >= this.getDimensions()[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int[] getDataOffsets(int[] nArray) {
        int[] nArray2 = this.getDimensionLinearOffsets();
        int[] nArray3 = this.getChunkDimensions();
        int n = this.getDataType().getSize();
        int[] nArray4 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            int[] nArray5 = Utils.linearIndexToDimensionIndex(nArray[n2] / n, nArray3);
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray5.length) {
                n3 += nArray5[n4] * nArray2[n4];
                ++n4;
            }
            nArray4[n2] = n3;
            ++n2;
        }
        return nArray4;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        logger.trace("Getting data buffer for {}", (Object)this.getPath());
        byte[] byArray = new byte[Math.toIntExact(this.getDiskSize())];
        logger.trace("Created data buffer for '{}' of size {} bytes", (Object)this.getPath(), (Object)byArray.length);
        int n = this.getDataType().getSize();
        Collection<Chunk> collection = this.getAllChunks();
        int[] nArray = this.getChunkDimensions();
        int[] nArray2 = this.getChunkInternalOffsets(nArray, n);
        int[] nArray3 = this.getDataOffsets(nArray2);
        int n2 = nArray[nArray.length - 1];
        collection.parallelStream().forEach(chunk -> this.fillDataFromChunk((Chunk)chunk, byArray, nArray, nArray2, nArray3, n2, n));
        return ByteBuffer.wrap(byArray);
    }

    protected abstract Collection<Chunk> getAllChunks();

    protected abstract int[] getChunkDimensions();

    private int[] getDimensionLinearOffsets() {
        int n = this.getDimensions().length;
        int[] nArray = new int[n];
        Arrays.fill(nArray, 1);
        int n2 = 0;
        while (n2 < nArray.length - 1) {
            int n3 = n2 + 1;
            while (n3 < nArray.length) {
                int n4 = n2;
                nArray[n4] = nArray[n4] * this.getDimensions()[n3];
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    protected int[] getChunkInternalOffsets(int[] nArray, int n3) {
        int n4 = nArray[nArray.length - 1];
        int n5 = Arrays.stream(nArray).limit((long)nArray.length - 1L).reduce(1, (n, n2) -> n * n2);
        int[] nArray2 = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = n6 * n4 * n3;
            ++n6;
        }
        return nArray2;
    }

    private boolean isPartialChunk(Chunk chunk) {
        int[] nArray = this.getDimensions();
        int[] nArray2 = chunk.getChunkOffset();
        int[] nArray3 = this.getChunkDimensions();
        int n = 0;
        while (n < nArray2.length) {
            if (nArray2[n] + nArray3[n] > nArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private byte[] decompressChunk(Chunk chunk) {
        ByteBuffer byteBuffer = this.getDataBuffer(chunk);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        try {
            FilterPipeline filterPipeline = (FilterPipeline)this.lazyPipeline.get();
            if (filterPipeline == null) {
                logger.debug("No filters returning decoded chunk '{}'", (Object)chunk);
                return byArray;
            }
            byte[] byArray2 = filterPipeline.decode(byArray);
            logger.debug("Decoded {}", (Object)chunk);
            return byArray2;
        }
        catch (ConcurrentException concurrentException) {
            throw new HdfException("Failed to get filter pipeline", concurrentException);
        }
    }

    private ByteBuffer getDataBuffer(Chunk chunk) {
        try {
            return this.hdfFc.map(chunk.getAddress(), chunk.getSize());
        }
        catch (Exception exception) {
            throw new HdfException("Failed to read chunk for dataset '" + this.getPath() + "' at address " + chunk.getAddress());
        }
    }

    protected final class FilterPipelineLazyInitializer
    extends LazyInitializer<FilterPipeline> {
        protected FilterPipelineLazyInitializer() {
        }

        protected FilterPipeline initialize() {
            logger.debug("Lazy initializing filter pipeline for '{}'", (Object)ChunkedDatasetBase.this.getPath());
            if (ChunkedDatasetBase.this.oh.hasMessageOfType(FilterPipelineMessage.class)) {
                FilterPipelineMessage filterPipelineMessage = ChunkedDatasetBase.this.oh.getMessageOfType(FilterPipelineMessage.class);
                return FilterManager.getPipeline(filterPipelineMessage);
            }
            return null;
        }
    }
}

