/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.dataset.chunked.Chunk;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class ChunkImpl
implements Chunk {
    private static final BitSet NOT_FILTERED_MASK = BitSet.valueOf(new byte[4]);
    private final long address;
    private final int size;
    private final int[] chunkOffset;
    private final BitSet filterMask;

    public ChunkImpl(long l, int n, int[] nArray) {
        this(l, n, nArray, NOT_FILTERED_MASK);
    }

    public ChunkImpl(long l, int n, int[] nArray, BitSet bitSet) {
        this.address = l;
        this.size = n;
        this.chunkOffset = nArray;
        this.filterMask = bitSet;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public BitSet getFilterMask() {
        return this.filterMask;
    }

    @Override
    public int[] getChunkOffset() {
        return this.chunkOffset;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChunkImpl chunkImpl = (ChunkImpl)object;
        return this.address == chunkImpl.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "ChunkImpl{address=" + this.address + ", size=" + this.size + ", chunkOffset=" + Arrays.toString(this.chunkOffset) + ", filterMask=" + String.valueOf(this.filterMask) + "}";
    }
}

