/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class ExtensibleArrayIndex
implements ChunkIndex {
    private static final byte[] EXTENSIBLE_ARRAY_HEADER_SIGNATURE = "EAHD".getBytes();
    private static final byte[] EXTENSIBLE_ARRAY_INDEX_BLOCK_SIGNATURE = "EAIB".getBytes();
    private static final byte[] EXTENSIBLE_ARRAY_DATA_BLOCK_SIGNATURE = "EADB".getBytes();
    private static final byte[] EXTENSIBLE_ARRAY_SECONDARY_BLOCK_SIGNATURE = "EASB".getBytes();
    private final long headerAddress;
    private final int clientId;
    private final boolean filtered;
    private final int elementSize;
    private final int numberOfElementsInIndexBlock;
    private final int numberOfElements;
    private final int numberOfSecondaryBlocks;
    private final int blockOffsetSize;
    private final int dataBlockSize;
    private final int secondaryBlockSize;
    private final List<Chunk> chunks;
    private final int unfilteredChunkSize;
    private final int[] datasetDimensions;
    private final int minNumberOfElementsInDataBlock;
    private final ExtensibleArrayCounter dataBlockElementCounter;
    private final int minNumberOfDataBlockPointers;
    private final ExtensibleArraySecondaryBlockPointerCounter secondaryBlockPointerCounter;
    private final int maxNumberOfElementsInDataBlockPageBits;
    private final int extensibleArrayElementSize;
    private int elementCounter = 0;

    public ExtensibleArrayIndex(HdfFileChannel hdfFileChannel, long l, int n, int n2, int[] nArray) {
        this.headerAddress = l;
        this.unfilteredChunkSize = n;
        this.elementSize = n2;
        this.datasetDimensions = nArray;
        int n3 = 16 + hdfFileChannel.getSizeOfOffsets() + 6 * hdfFileChannel.getSizeOfLengths();
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n3);
        this.verifySignature(byteBuffer, EXTENSIBLE_ARRAY_HEADER_SIGNATURE);
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new HdfException("Unsupported extensible array index version detected. Version: " + by);
        }
        this.clientId = byteBuffer.get();
        if (this.clientId == 0) {
            this.filtered = false;
        } else if (this.clientId == 1) {
            this.filtered = true;
        } else {
            throw new UnsupportedHdfException("Extensible array unsupported client ID: " + this.clientId);
        }
        this.extensibleArrayElementSize = byteBuffer.get();
        byte by2 = byteBuffer.get();
        this.blockOffsetSize = by2 / 8;
        this.numberOfElementsInIndexBlock = byteBuffer.get();
        this.minNumberOfElementsInDataBlock = byteBuffer.get();
        this.dataBlockElementCounter = new ExtensibleArrayCounter(this.minNumberOfElementsInDataBlock);
        this.minNumberOfDataBlockPointers = byteBuffer.get();
        this.secondaryBlockPointerCounter = new ExtensibleArraySecondaryBlockPointerCounter(this.minNumberOfDataBlockPointers);
        this.maxNumberOfElementsInDataBlockPageBits = byteBuffer.get();
        this.numberOfSecondaryBlocks = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        this.secondaryBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        this.dataBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        int n4 = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        this.chunks = new ArrayList<Chunk>(n4);
        this.numberOfElements = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        int n5 = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        new ExtensibleArrayIndexBlock(hdfFileChannel, n5);
    }

    private void verifySignature(ByteBuffer byteBuffer, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byteBuffer.get(byArray2, 0, byArray.length);
        if (!Arrays.equals(byArray, byArray2)) {
            String string = new String(byArray);
            throw new HdfException("Signature '" + string + "' not matched, at address ");
        }
    }

    @Override
    public Collection<Chunk> getAllChunks() {
        return this.chunks;
    }

    static class ExtensibleArrayCounter {
        private final int minNumberOfElementsInDataBlock;
        private int blockSizeMultiplier = 1;
        private int numberOfBlocks = 1;
        private int blockCounter = 0;
        private boolean increaseNumberOfBlocksNext = false;

        ExtensibleArrayCounter(int n) {
            this.minNumberOfElementsInDataBlock = n;
        }

        public int getNextNumberOfChunks() {
            if (this.blockCounter < this.numberOfBlocks) {
                ++this.blockCounter;
            } else if (this.increaseNumberOfBlocksNext) {
                this.increaseNumberOfBlocksNext = false;
                this.numberOfBlocks *= 2;
                this.blockCounter = 1;
            } else {
                this.increaseNumberOfBlocksNext = true;
                this.blockSizeMultiplier *= 2;
                this.blockCounter = 1;
            }
            return this.blockSizeMultiplier * this.minNumberOfElementsInDataBlock;
        }

        public String toString() {
            return "ExtensibleArrayCounter{minNumberOfElementsInDataBlock=" + this.minNumberOfElementsInDataBlock + ", blockSizeMultiplier=" + this.blockSizeMultiplier + ", numberOfBlocks=" + this.numberOfBlocks + ", blockCounter=" + this.blockCounter + ", increaseNumberOfBlocksNext=" + this.increaseNumberOfBlocksNext + "}";
        }
    }

    private class ExtensibleArrayIndexBlock {
        private ExtensibleArrayIndexBlock(HdfFileChannel hdfFileChannel, long l) {
            long l2;
            int n = 6 + hdfFileChannel.getSizeOfOffsets() + hdfFileChannel.getSizeOfOffsets() * ExtensibleArrayIndex.this.numberOfElementsInIndexBlock + 6 * ExtensibleArrayIndex.this.extensibleArrayElementSize + ExtensibleArrayIndex.this.numberOfSecondaryBlocks * hdfFileChannel.getSizeOfOffsets() + 4;
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            ExtensibleArrayIndex.this.verifySignature(byteBuffer, EXTENSIBLE_ARRAY_INDEX_BLOCK_SIGNATURE);
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported fixed array data block version detected. Version: " + by);
            }
            byte by2 = byteBuffer.get();
            if (by2 != ExtensibleArrayIndex.this.clientId) {
                throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
            }
            long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            if (l3 != ExtensibleArrayIndex.this.headerAddress) {
                throw new HdfException("Extensible array data block header address mismatch");
            }
            boolean bl = true;
            int n2 = 0;
            while (bl && n2 < ExtensibleArrayIndex.this.numberOfElementsInIndexBlock) {
                bl = this.readElement(byteBuffer, hdfFileChannel);
                ++n2;
            }
            if (bl && ExtensibleArrayIndex.this.numberOfElements > ExtensibleArrayIndex.this.numberOfElementsInIndexBlock) {
                n2 = 0;
                while (n2 < 6) {
                    l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                    if (l2 == -1L) break;
                    new ExtensibleArrayDataBlock(hdfFileChannel, l2);
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < ExtensibleArrayIndex.this.numberOfSecondaryBlocks) {
                l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                new ExtensibleArraySecondaryBlock(hdfFileChannel, l2);
                ++n2;
            }
        }

        private boolean readElement(ByteBuffer byteBuffer, HdfFileChannel hdfFileChannel) {
            long l = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            if (l != -1L) {
                int[] nArray = Utils.linearIndexToDimensionIndex(ExtensibleArrayIndex.this.elementCounter * ExtensibleArrayIndex.this.unfilteredChunkSize / ExtensibleArrayIndex.this.elementSize, ExtensibleArrayIndex.this.datasetDimensions);
                if (ExtensibleArrayIndex.this.filtered) {
                    int n = Utils.readBytesAsUnsignedInt(byteBuffer, ExtensibleArrayIndex.this.extensibleArrayElementSize - hdfFileChannel.getSizeOfOffsets() - 4);
                    BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get(), byteBuffer.get(), byteBuffer.get(), byteBuffer.get()});
                    ExtensibleArrayIndex.this.chunks.add(new ChunkImpl(l, n, nArray, bitSet));
                } else {
                    ExtensibleArrayIndex.this.chunks.add(new ChunkImpl(l, ExtensibleArrayIndex.this.unfilteredChunkSize, nArray));
                }
                ++ExtensibleArrayIndex.this.elementCounter;
                return true;
            }
            return false;
        }

        private class ExtensibleArrayDataBlock {
            private ExtensibleArrayDataBlock(HdfFileChannel hdfFileChannel, long l) {
                int n = ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.dataBlockElementCounter.getNextNumberOfChunks();
                int n2 = 6 + hdfFileChannel.getSizeOfOffsets() + ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.blockOffsetSize + n * ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.extensibleArrayElementSize + 4;
                ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n2);
                ExtensibleArrayIndex.this.verifySignature(byteBuffer, EXTENSIBLE_ARRAY_DATA_BLOCK_SIGNATURE);
                byte by = byteBuffer.get();
                if (by != 0) {
                    throw new HdfException("Unsupported extensible array data block version detected. Version: " + by);
                }
                byte by2 = byteBuffer.get();
                if (by2 != ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.clientId) {
                    throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
                }
                long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                if (l2 != ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.headerAddress) {
                    throw new HdfException("Extensible array data block header address mismatch");
                }
                Utils.readBytesAsUnsignedLong(byteBuffer, ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.blockOffsetSize);
                boolean bl = true;
                int n3 = 0;
                while (bl && n3 < n) {
                    bl = ExtensibleArrayIndexBlock.this.readElement(byteBuffer, hdfFileChannel);
                    ++n3;
                }
            }
        }

        private class ExtensibleArraySecondaryBlock {
            private ExtensibleArraySecondaryBlock(HdfFileChannel hdfFileChannel, long l) {
                int n = ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.secondaryBlockPointerCounter.getNextNumberOfPointers();
                int n2 = 6 + hdfFileChannel.getSizeOfOffsets() + ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.blockOffsetSize + n * ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.extensibleArrayElementSize + 4;
                ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n2);
                ExtensibleArrayIndex.this.verifySignature(byteBuffer, EXTENSIBLE_ARRAY_SECONDARY_BLOCK_SIGNATURE);
                byte by = byteBuffer.get();
                if (by != 0) {
                    throw new HdfException("Unsupported fixed array data block version detected. Version: " + by);
                }
                byte by2 = byteBuffer.get();
                if (by2 != ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.clientId) {
                    throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
                }
                long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                if (l2 != ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.headerAddress) {
                    throw new HdfException("Extensible array secondary block header address mismatch");
                }
                Utils.readBytesAsUnsignedLong(byteBuffer, ((ExtensibleArrayIndexBlock)ExtensibleArrayIndexBlock.this).ExtensibleArrayIndex.this.blockOffsetSize);
                int n3 = 0;
                while (n3 < n) {
                    long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                    if (l3 == -1L) break;
                    new ExtensibleArrayDataBlock(hdfFileChannel, l3);
                    ++n3;
                }
            }
        }
    }

    static class ExtensibleArraySecondaryBlockPointerCounter {
        private static final int REPEATS = 2;
        private int numberOfPointers;
        private int counter = 0;

        ExtensibleArraySecondaryBlockPointerCounter(int n) {
            this.numberOfPointers = n;
        }

        public int getNextNumberOfPointers() {
            if (this.counter < 2) {
                ++this.counter;
            } else {
                this.numberOfPointers *= 2;
                this.counter = 1;
            }
            return this.numberOfPointers;
        }
    }
}

