/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class FixedArrayIndex
implements ChunkIndex {
    private static final byte[] FIXED_ARRAY_HEADER_SIGNATURE = "FAHD".getBytes();
    private static final byte[] FIXED_ARRAY_DATA_BLOCK_SIGNATURE = "FADB".getBytes();
    private final long address;
    private final int unfilteredChunkSize;
    private final int elementSize;
    private final int[] datasetDimensions;
    private final int clientId;
    private final int entrySize;
    private final int pageBits;
    private final int maxNumberOfEntries;
    private final long dataBlockAddress;
    private final List<Chunk> chunks;

    public FixedArrayIndex(HdfFileChannel hdfFileChannel, long l, int n, int n2, int[] nArray) {
        this.address = l;
        this.unfilteredChunkSize = n;
        this.elementSize = n2;
        this.datasetDimensions = nArray;
        int n3 = 12 + hdfFileChannel.getSizeOfOffsets() + hdfFileChannel.getSizeOfLengths();
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n3);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray, 0, byArray.length);
        if (!Arrays.equals(FIXED_ARRAY_HEADER_SIGNATURE, byArray)) {
            throw new HdfException("Fixed array header signature 'FAHD' not matched, at address " + l);
        }
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new HdfException("Unsupported fixed array index version detected. Version: " + by);
        }
        this.clientId = byteBuffer.get();
        this.entrySize = byteBuffer.get();
        this.pageBits = byteBuffer.get();
        this.maxNumberOfEntries = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
        this.dataBlockAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
        this.chunks = new ArrayList<Chunk>(this.maxNumberOfEntries);
        new FixedArrayDataBlock(hdfFileChannel, this.dataBlockAddress);
    }

    @Override
    public Collection<Chunk> getAllChunks() {
        return this.chunks;
    }

    private class FixedArrayDataBlock {
        private FixedArrayDataBlock(HdfFileChannel hdfFileChannel, long l) {
            int n = 6 + hdfFileChannel.getSizeOfOffsets() + FixedArrayIndex.this.entrySize * FixedArrayIndex.this.maxNumberOfEntries;
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(FIXED_ARRAY_DATA_BLOCK_SIGNATURE, byArray)) {
                throw new HdfException("Fixed array data block signature 'FADB' not matched, at address " + l);
            }
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported fixed array data block version detected. Version: " + by);
            }
            byte by2 = byteBuffer.get();
            if (by2 != FixedArrayIndex.this.clientId) {
                throw new HdfException("Fixed array client ID mismatch. Possible file corruption detected");
            }
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            if (l2 != FixedArrayIndex.this.address) {
                throw new HdfException("Fixed array data block header address missmatch");
            }
            if (by2 == 0) {
                int n2 = 0;
                while (n2 < FixedArrayIndex.this.maxNumberOfEntries) {
                    long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                    int[] nArray = Utils.linearIndexToDimensionIndex(n2 * FixedArrayIndex.this.unfilteredChunkSize / FixedArrayIndex.this.elementSize, FixedArrayIndex.this.datasetDimensions);
                    FixedArrayIndex.this.chunks.add(new ChunkImpl(l3, FixedArrayIndex.this.unfilteredChunkSize, nArray));
                    ++n2;
                }
            } else if (by2 == 1) {
                int n3 = 0;
                while (n3 < FixedArrayIndex.this.maxNumberOfEntries) {
                    long l4 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                    int n4 = Utils.readBytesAsUnsignedInt(byteBuffer, FixedArrayIndex.this.entrySize - hdfFileChannel.getSizeOfOffsets() - 4);
                    BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get(), byteBuffer.get(), byteBuffer.get(), byteBuffer.get()});
                    int[] nArray = Utils.linearIndexToDimensionIndex(n3 * FixedArrayIndex.this.unfilteredChunkSize / FixedArrayIndex.this.elementSize, FixedArrayIndex.this.datasetDimensions);
                    FixedArrayIndex.this.chunks.add(new ChunkImpl(l4, n4, nArray, bitSet));
                    ++n3;
                }
            } else {
                throw new HdfException("Unrecognized client ID  = " + by2);
            }
        }
    }
}

