/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.filter.Filter;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeflatePipelineFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DeflatePipelineFilter.class);

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String getName() {
        return "deflate";
    }

    @Override
    public byte[] decode(byte[] byArray, int[] nArray) {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 3);
            byte[] byArray2 = new byte[4096];
            while (!inflater.finished()) {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Decompressed chunk. Compressed size = {} bytes, Decompressed size = {}", (Object)inflater.getBytesRead(), (Object)inflater.getBytesWritten());
            }
            inflater.end();
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new HdfFilterException("Inflating failed", dataFormatException);
        }
    }
}

