/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.filter.ByteShuffleFilter;
import io.jhdf.filter.DeflatePipelineFilter;
import io.jhdf.filter.Filter;
import io.jhdf.filter.FilterPipeline;
import io.jhdf.filter.FletcherChecksumFilter;
import io.jhdf.object.message.FilterPipelineMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FilterManager {

    private static final Logger logger = LoggerFactory.getLogger(FilterManager.class);
    private static final Map<Integer, Filter> ID_TO_FILTER = new HashMap<Integer, Filter>();

    static {
        logger.info("Initializing HDF5 filters...");
        FilterManager.addFilter(new DeflatePipelineFilter());
        FilterManager.addFilter(new ByteShuffleFilter());
        FilterManager.addFilter(new FletcherChecksumFilter());
        ServiceLoader<Filter> serviceLoader = ServiceLoader.load(Filter.class);
        for (Filter filter : serviceLoader) {
            FilterManager.addFilter(filter);
        }
        logger.info("Initialized HDF5 filters");
    }

    public static void addFilter(Filter filter) {
        ID_TO_FILTER.put(filter.getId(), filter);
        logger.info("Added HDF5 filter '{}' with ID '{}'", (Object)filter.getName(), (Object)filter.getId());
    }

    public static FilterPipeline getPipeline(FilterPipelineMessage filterPipelineMessage) {
        List<FilterPipelineMessage.FilterInfo> list = filterPipelineMessage.getFilters();
        if (!list.stream().allMatch(filterInfo -> ID_TO_FILTER.containsKey(filterInfo.getId()))) {
            FilterPipelineMessage.FilterInfo filterInfo2 = list.stream().filter(filterInfo -> !ID_TO_FILTER.containsKey(filterInfo.getId())).findFirst().orElseThrow(() -> new HdfException("Failed to determine missing filter"));
            throw new HdfFilterException("A required filter is not available: name='" + filterInfo2.getName() + "' id=" + filterInfo2.getId());
        }
        Collections.reverse(list);
        FilterPipeline filterPipeline = new FilterPipeline();
        list.forEach(filterInfo -> filterPipeline.addFilter(ID_TO_FILTER.get(filterInfo.getId()), filterInfo.getData()));
        return filterPipeline;
    }
}

