/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.links;

import io.jhdf.HdfFile;
import io.jhdf.api.Group;
import io.jhdf.api.Link;
import io.jhdf.api.Node;
import io.jhdf.exceptions.HdfBrokenLinkException;
import io.jhdf.links.AbstractLink;
import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class ExternalLink
extends AbstractLink
implements Link {
    private final String targetFile;
    private final String targetPath;

    public ExternalLink(String string, String string2, String string3, Group group) {
        super(string3, group);
        this.targetFile = string;
        this.targetPath = string2;
        this.targetNode = new ExternalLinkTargetLazyInitializer();
    }

    @Override
    public Node getTarget() {
        try {
            return (Node)this.targetNode.get();
        }
        catch (Exception exception) {
            throw new HdfBrokenLinkException("Could not resolve link target '" + this.targetPath + "' in external file '" + this.targetFile + "' from link '" + this.getPath() + "'", exception);
        }
    }

    @Override
    public String getTargetPath() {
        return this.targetFile + ":" + this.targetPath;
    }

    public String toString() {
        return "ExternalLink [name=" + this.name + ", targetFile=" + this.targetFile + ", targetPath=" + this.targetPath + "]";
    }

    private class ExternalLinkTargetLazyInitializer
    extends LazyInitializer<Node> {
        private ExternalLinkTargetLazyInitializer() {
        }

        protected Node initialize() {
            HdfFile hdfFile = new HdfFile(this.getTargetFile());
            ExternalLink.this.getHdfFile().addExternalFile(hdfFile);
            return hdfFile.getByPath(ExternalLink.this.targetPath);
        }

        private File getTargetFile() {
            if (ExternalLink.this.targetFile.startsWith(File.separator)) {
                return Paths.get(ExternalLink.this.targetFile, new String[0]).toFile();
            }
            String string = ExternalLink.this.parent.getFile().getParent();
            return Paths.get(string, ExternalLink.this.targetFile).toFile();
        }
    }
}

