/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.object.datatype.DataType;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class ArrayDataType
extends DataType {
    private final DataType baseType;
    private final int[] dimensions;

    public ArrayDataType(ByteBuffer byteBuffer) {
        super(byteBuffer);
        int n = Utils.readBytesAsUnsignedInt(byteBuffer, 1);
        this.dimensions = new int[n];
        if (this.getVersion() == 2) {
            byteBuffer.position(byteBuffer.position() + 3);
        }
        int n2 = 0;
        while (n2 < this.dimensions.length) {
            this.dimensions[n2] = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
            if (this.getVersion() == 2) {
                byteBuffer.position(byteBuffer.position() + 4);
            }
            ++n2;
        }
        this.baseType = DataType.readDataType(byteBuffer);
    }

    @Override
    public Class<?> getJavaType() {
        return Array.newInstance(this.baseType.getJavaType(), 0).getClass();
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }
}

