/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.ArrayDataType;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.EnumDataType;
import io.jhdf.object.datatype.FixedPoint;
import io.jhdf.object.datatype.FloatingPoint;
import io.jhdf.object.datatype.Reference;
import io.jhdf.object.datatype.StringData;
import io.jhdf.object.datatype.VariableLength;
import java.nio.ByteBuffer;
import java.util.BitSet;

public abstract class DataType {
    private final int version;
    private final int dataClass;
    private final int size;
    protected final BitSet classBits;

    public static DataType readDataType(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get()});
        int n = Utils.bitsToInt(bitSet, 4, 4);
        int n2 = Utils.bitsToInt(bitSet, 0, 4);
        if (n == 0 || n > 3) {
            throw new HdfException("Unrecognized datatype version '" + n + "' detected");
        }
        byteBuffer.reset();
        switch (n2) {
            case 0: {
                return new FixedPoint(byteBuffer);
            }
            case 1: {
                return new FloatingPoint(byteBuffer);
            }
            case 2: {
                throw new UnsupportedHdfException("Time data type is not yet supported");
            }
            case 3: {
                return new StringData(byteBuffer);
            }
            case 4: {
                throw new UnsupportedHdfException("Bit field data type is not yet supported");
            }
            case 5: {
                throw new UnsupportedHdfException("Opaque data type is not yet supported");
            }
            case 6: {
                return new CompoundDataType(byteBuffer);
            }
            case 7: {
                return new Reference(byteBuffer);
            }
            case 8: {
                return new EnumDataType(byteBuffer);
            }
            case 9: {
                return new VariableLength(byteBuffer);
            }
            case 10: {
                return new ArrayDataType(byteBuffer);
            }
        }
        throw new HdfException("Unrecognized data class = " + n2);
    }

    protected DataType(ByteBuffer byteBuffer) {
        BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get()});
        this.dataClass = Utils.bitsToInt(bitSet, 0, 4);
        this.version = Utils.bitsToInt(bitSet, 4, 4);
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray);
        this.classBits = BitSet.valueOf(byArray);
        this.size = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataClass() {
        return this.dataClass;
    }

    public int getSize() {
        return this.size;
    }

    public abstract Class<?> getJavaType();
}

