/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EnumDataType
extends DataType {
    private final DataType baseType;
    private final Map<Integer, String> ordinalToName;

    public EnumDataType(ByteBuffer byteBuffer) {
        super(byteBuffer);
        int n;
        this.baseType = DataType.readDataType(byteBuffer);
        int n2 = Utils.bitsToInt(this.classBits, 0, 16);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getVersion() == 3) {
            var4_4 = 0;
            while (var4_4 < n2) {
                arrayList.add(Utils.readUntilNull(byteBuffer));
                ++var4_4;
            }
        } else {
            var4_4 = 0;
            while (var4_4 < n2) {
                n = byteBuffer.position();
                arrayList.add(Utils.readUntilNull(byteBuffer));
                int n3 = byteBuffer.position();
                int n4 = (n3 - n) % 8;
                if (n4 != 0) {
                    int n5 = 8 - n4;
                    byteBuffer.position(byteBuffer.position() + n5);
                }
                ++var4_4;
            }
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        n = 0;
        while (n < n2) {
            arrayList2.add(Utils.readBytesAsUnsignedInt(byteBuffer, this.baseType.getSize()));
            ++n;
        }
        this.ordinalToName = new HashMap<Integer, String>();
        n = 0;
        while (n < n2) {
            this.ordinalToName.put((Integer)arrayList2.get(n), (String)arrayList.get(n));
            ++n;
        }
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public Map<Integer, String> getEnumMapping() {
        return this.ordinalToName;
    }
}

