/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FixedPoint
extends DataType
implements OrderedDataType {
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean signed;
    private final short bitOffset;
    private final short bitPrecision;

    public FixedPoint(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.signed = this.classBits.get(3);
        this.bitOffset = byteBuffer.getShort();
        this.bitPrecision = byteBuffer.getShort();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.signed) {
            switch (this.bitPrecision) {
                case 8: {
                    return Byte.TYPE;
                }
                case 16: {
                    return Short.TYPE;
                }
                case 32: {
                    return Integer.TYPE;
                }
                case 64: {
                    return Long.TYPE;
                }
            }
            throw new HdfTypeException("Unsupported signed fixed point data type");
        }
        switch (this.bitPrecision) {
            case 8: 
            case 16: {
                return Integer.TYPE;
            }
            case 32: {
                return Long.TYPE;
            }
            case 64: {
                return BigInteger.class;
            }
        }
        throw new HdfTypeException("Unsupported signed fixed point data type");
    }
}

