/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FloatingPoint
extends DataType
implements OrderedDataType {
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean internalPadding;
    private final int mantissaNormalization;
    private final int signLocation;
    private final short bitOffset;
    private final short bitPrecision;
    private final byte exponentLocation;
    private final byte exponentSize;
    private final byte mantissaLocation;
    private final byte mantissaSize;
    private final int exponentBias;

    public FloatingPoint(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (this.classBits.get(6)) {
            throw new UnsupportedHdfException("VAX endian is not supported");
        }
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.internalPadding = this.classBits.get(3);
        this.mantissaNormalization = Utils.bitsToInt(this.classBits, 4, 2);
        this.signLocation = Utils.bitsToInt(this.classBits, 8, 8);
        this.bitOffset = byteBuffer.getShort();
        this.bitPrecision = byteBuffer.getShort();
        this.exponentLocation = byteBuffer.get();
        this.exponentSize = byteBuffer.get();
        this.mantissaLocation = byteBuffer.get();
        this.mantissaSize = byteBuffer.get();
        this.exponentBias = byteBuffer.getInt();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isInternalPadding() {
        return this.internalPadding;
    }

    public int getMantissaNormalization() {
        return this.mantissaNormalization;
    }

    public int getSignLocation() {
        return this.signLocation;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    public byte getExponentLocation() {
        return this.exponentLocation;
    }

    public byte getExponentSize() {
        return this.exponentSize;
    }

    public byte getMantissaLocation() {
        return this.mantissaLocation;
    }

    public byte getMantissaSize() {
        return this.mantissaSize;
    }

    public int getExponentBias() {
        return this.exponentBias;
    }

    @Override
    public Class<?> getJavaType() {
        switch (this.bitPrecision) {
            case 16: 
            case 32: {
                return Float.TYPE;
            }
            case 64: {
                return Double.TYPE;
            }
        }
        throw new HdfTypeException("Unsupported signed fixed point data type");
    }
}

