/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringData
extends DataType {
    private final boolean nullTerminated;
    private final boolean nullPad;
    private final boolean spacePad;
    private final Charset charset;

    public StringData(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.nullTerminated = this.classBits.get(0);
        this.nullPad = this.classBits.get(1);
        this.spacePad = this.classBits.get(2);
        int n = Utils.bitsToInt(this.classBits, 4, 4);
        switch (n) {
            case 0: {
                this.charset = StandardCharsets.US_ASCII;
                break;
            }
            case 1: {
                this.charset = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized Charset. Index is: " + n);
            }
        }
    }

    public boolean isNullTerminated() {
        return this.nullTerminated;
    }

    public boolean isNullPad() {
        return this.nullPad;
    }

    public boolean isSpacePad() {
        return this.spacePad;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return "StringData [nullTerminated=" + this.nullTerminated + ", nullPad=" + this.nullPad + ", spacePad=" + this.spacePad + ", charset=" + String.valueOf(this.charset) + "]";
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }
}

