/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class VariableLength
extends DataType {
    private final int type;
    private final int paddingType;
    private final Charset encoding;
    private final DataType parent;

    public VariableLength(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.type = Utils.bitsToInt(this.classBits, 0, 4);
        this.paddingType = Utils.bitsToInt(this.classBits, 4, 4);
        int n = Utils.bitsToInt(this.classBits, 8, 4);
        switch (n) {
            case 0: {
                this.encoding = StandardCharsets.US_ASCII;
                break;
            }
            case 1: {
                this.encoding = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized character encoding = " + n);
            }
        }
        this.parent = DataType.readDataType(byteBuffer);
    }

    public int getType() {
        return this.type;
    }

    public int getPaddingType() {
        return this.paddingType;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public DataType getParent() {
        return this.parent;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.type == 1) {
            return String.class;
        }
        return this.parent.getJavaType();
    }
}

