/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(AttributeMessage.class);
    private static final int DATA_TYPE_SHARED = 0;
    private static final int DATA_SPACE_SHARED = 0;
    private final byte version;
    private final String name;
    private final DataType dataType;
    private final DataSpace dataSpace;
    private final ByteBuffer data;

    public AttributeMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
        super(bitSet);
        this.version = byteBuffer.get();
        logger.trace("Version: {}", (Object)this.version);
        if (this.version == 1) {
            byteBuffer.position(byteBuffer.position() + 1);
            int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n3 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.name = Utils.readUntilNull(Utils.createSubBuffer(byteBuffer, n));
            logger.trace("Name: {}", (Object)this.name);
            Utils.seekBufferToNextMultipleOfEight(byteBuffer);
            this.dataType = DataType.readDataType(Utils.createSubBuffer(byteBuffer, n2));
            logger.trace("Datatype: {}", (Object)this.dataType);
            Utils.seekBufferToNextMultipleOfEight(byteBuffer);
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(byteBuffer, n3), superblock);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            Utils.seekBufferToNextMultipleOfEight(byteBuffer);
            int n4 = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = n4 == 0 ? null : Utils.createSubBuffer(byteBuffer, n4);
        } else if (this.version == 2) {
            BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get()});
            int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n5 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n6 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.name = Utils.readUntilNull(Utils.createSubBuffer(byteBuffer, n));
            logger.trace("Name: {}", (Object)this.name);
            if (bitSet2.get(0)) {
                throw new UnsupportedHdfException("Attribute contains shared data type");
            }
            this.dataType = DataType.readDataType(Utils.createSubBuffer(byteBuffer, n5));
            logger.trace("Datatype: {}", (Object)this.dataType);
            if (bitSet2.get(0)) {
                throw new UnsupportedHdfException("Attribute contains shared data space");
            }
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(byteBuffer, n6), superblock);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            int n7 = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = n7 == 0 ? null : Utils.createSubBuffer(byteBuffer, n7);
        } else if (this.version == 3) {
            BitSet bitSet3 = BitSet.valueOf(new byte[]{byteBuffer.get()});
            int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n8 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n9 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            byte by = byteBuffer.get();
            Charset charset = switch (by) {
                case 0 -> StandardCharsets.US_ASCII;
                case 1 -> StandardCharsets.UTF_8;
                default -> throw new UnsupportedHdfException("Unrecognized character set detected: " + by);
            };
            ByteBuffer byteBuffer2 = Utils.createSubBuffer(byteBuffer, n);
            this.name = charset.decode(byteBuffer2).toString().trim();
            logger.trace("Name: {}", (Object)this.name);
            if (bitSet3.get(0)) {
                throw new UnsupportedHdfException("Attribute contains shared data type");
            }
            this.dataType = DataType.readDataType(Utils.createSubBuffer(byteBuffer, n8));
            logger.trace("Datatype: {}", (Object)this.dataType);
            if (bitSet3.get(0)) {
                throw new UnsupportedHdfException("Attribute contains shared data space");
            }
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(byteBuffer, n9), superblock);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            int n10 = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = n10 == 0 ? null : Utils.createSubBuffer(byteBuffer, n10);
        } else {
            throw new UnsupportedHdfException("Unsupported Attribute message version. Detected version: " + this.version);
        }
        logger.debug("Read attribute: {}", (Object)this.name);
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataSpace getDataSpace() {
        return this.dataSpace;
    }

    public ByteBuffer getDataBuffer() {
        if (this.data == null) {
            return null;
        }
        return this.data.slice().order(this.data.order());
    }

    public String toString() {
        return "AttributeMessage [name=" + this.name + ", dataType=" + String.valueOf(this.dataType) + ", dataSpace=" + String.valueOf(this.dataSpace) + "]";
    }
}

