/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public abstract class DataLayoutMessage
extends Message {
    public DataLayoutMessage(BitSet bitSet) {
        super(bitSet);
    }

    public abstract DataLayout getDataLayout();

    public static DataLayoutMessage createDataLayoutMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
        byte by = byteBuffer.get();
        if (by != 3 && by != 4) {
            throw new UnsupportedHdfException("Only v3 and v4 data layout messages are supported. Detected version = " + by);
        }
        byte by2 = byteBuffer.get();
        switch (by2) {
            case 0: {
                return new CompactDataLayoutMessage(byteBuffer, bitSet);
            }
            case 1: {
                return new ContiguousDataLayoutMessage(byteBuffer, superblock, bitSet);
            }
            case 2: {
                if (by == 3) {
                    return new ChunkedDataLayoutMessageV3(byteBuffer, superblock, bitSet);
                }
                return new ChunkedDataLayoutMessageV4(byteBuffer, superblock, bitSet);
            }
            case 3: {
                throw new UnsupportedHdfException("Virtual storage is not supported");
            }
        }
        throw new UnsupportedHdfException("Unknown storage layout " + by2);
    }

    public static class ChunkedDataLayoutMessageV3
    extends DataLayoutMessage {
        private final long address;
        private final int size;
        private final int[] chunkDimensions;

        private ChunkedDataLayoutMessageV3(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
            super(bitSet);
            int n = byteBuffer.get() - 1;
            this.address = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
            this.chunkDimensions = new int[n];
            int n2 = 0;
            while (n2 < this.chunkDimensions.length) {
                this.chunkDimensions[n2] = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                ++n2;
            }
            this.size = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CHUNKED;
        }

        public long getBTreeAddress() {
            return this.address;
        }

        public int getSize() {
            return this.size;
        }

        public int[] getChunkDimensions() {
            return this.chunkDimensions;
        }
    }

    public static class ChunkedDataLayoutMessageV4
    extends DataLayoutMessage {
        private static final int DONT_FILTER_PARTIAL_BOUND_CHUNKS = 0;
        private static final int SINGLE_INDEX_WITH_FILTER = 1;
        private final long address;
        private final byte indexingType;
        private final int[] chunkDimensions;
        private byte pageBits;
        private byte maxBits;
        private byte indexElements;
        private byte minPointers;
        private byte minElements;
        private int nodeSize;
        private byte splitPercent;
        private byte mergePercent;
        private boolean isFilteredSingleChunk = false;
        private int sizeOfFilteredSingleChunk;
        private BitSet filterMaskFilteredSingleChunk;

        private ChunkedDataLayoutMessageV4(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
            super(bitSet);
            BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get()});
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            this.chunkDimensions = new int[by];
            int n = 0;
            while (n < this.chunkDimensions.length) {
                this.chunkDimensions[n] = Utils.readBytesAsUnsignedInt(byteBuffer, by2);
                ++n;
            }
            this.indexingType = byteBuffer.get();
            switch (this.indexingType) {
                case 1: {
                    if (!bitSet2.get(1)) break;
                    this.isFilteredSingleChunk = true;
                    this.sizeOfFilteredSingleChunk = Utils.readBytesAsUnsignedInt(byteBuffer, superblock.getSizeOfLengths());
                    this.filterMaskFilteredSingleChunk = BitSet.valueOf(new byte[]{byteBuffer.get(), byteBuffer.get(), byteBuffer.get(), byteBuffer.get()});
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.pageBits = byteBuffer.get();
                    break;
                }
                case 4: {
                    this.maxBits = byteBuffer.get();
                    this.indexElements = byteBuffer.get();
                    this.minPointers = byteBuffer.get();
                    this.minElements = byteBuffer.get();
                    this.pageBits = byteBuffer.get();
                    break;
                }
                case 5: {
                    this.nodeSize = byteBuffer.getInt();
                    this.splitPercent = byteBuffer.get();
                    this.mergePercent = byteBuffer.get();
                    break;
                }
                default: {
                    throw new UnsupportedHdfException("Unrecognized chunk indexing type. type=" + this.indexingType);
                }
            }
            this.address = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CHUNKED;
        }

        public long getAddress() {
            return this.address;
        }

        public byte getPageBits() {
            return this.pageBits;
        }

        public byte getMaxBits() {
            return this.maxBits;
        }

        public byte getIndexElements() {
            return this.indexElements;
        }

        public byte getMinPointers() {
            return this.minPointers;
        }

        public byte getMinElements() {
            return this.minElements;
        }

        public int getNodeSize() {
            return this.nodeSize;
        }

        public byte getSplitPercent() {
            return this.splitPercent;
        }

        public byte getMergePercent() {
            return this.mergePercent;
        }

        public byte getIndexingType() {
            return this.indexingType;
        }

        public int[] getChunkDimensions() {
            return this.chunkDimensions;
        }

        public int getSizeOfFilteredSingleChunk() {
            if (!this.isFilteredSingleChunk) {
                throw new HdfException("Requested size of filtered single chunk when its not set.");
            }
            return this.sizeOfFilteredSingleChunk;
        }

        public BitSet getFilterMaskFilteredSingleChunk() {
            if (!this.isFilteredSingleChunk) {
                throw new HdfException("Requested filter mask of filtered single chunk when its not set.");
            }
            return this.filterMaskFilteredSingleChunk;
        }

        public boolean isFilteredSingleChunk() {
            return this.isFilteredSingleChunk;
        }
    }

    public static class CompactDataLayoutMessage
    extends DataLayoutMessage {
        private final ByteBuffer dataBuffer;

        private CompactDataLayoutMessage(ByteBuffer byteBuffer, BitSet bitSet) {
            super(bitSet);
            int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.dataBuffer = Utils.createSubBuffer(byteBuffer, n);
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.COMPACT;
        }

        public ByteBuffer getDataBuffer() {
            return this.dataBuffer;
        }
    }

    public static class ContiguousDataLayoutMessage
    extends DataLayoutMessage {
        private final long address;
        private final long size;

        private ContiguousDataLayoutMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
            super(bitSet);
            this.address = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
            this.size = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfLengths());
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CONTIGUOUS;
        }

        public long getAddress() {
            return this.address;
        }

        public long getSize() {
            return this.size;
        }
    }
}

