/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.stream.IntStream;

public class DataSpace {
    private final byte version;
    private final boolean maxSizesPresent;
    private final int[] dimensions;
    private final int[] maxSizes;
    private final byte type;
    private final long totalLength;

    private DataSpace(ByteBuffer byteBuffer, Superblock superblock) {
        int n;
        this.version = byteBuffer.get();
        int n2 = byteBuffer.get();
        byte[] byArray = new byte[1];
        byteBuffer.get(byArray);
        BitSet bitSet = BitSet.valueOf(byArray);
        this.maxSizesPresent = bitSet.get(0);
        if (this.version == 1) {
            byteBuffer.position(byteBuffer.position() + 5);
            this.type = (byte)-1;
        } else if (this.version == 2) {
            this.type = byteBuffer.get();
        } else {
            throw new HdfException("Unrecognized version = " + this.version);
        }
        if (n2 != 0) {
            this.dimensions = new int[n2];
            n = 0;
            while (n < n2) {
                this.dimensions[n] = Utils.readBytesAsUnsignedInt(byteBuffer, superblock.getSizeOfLengths());
                ++n;
            }
        } else {
            this.dimensions = new int[0];
        }
        if (this.maxSizesPresent) {
            this.maxSizes = new int[n2];
            n = 0;
            while (n < n2) {
                this.maxSizes[n] = Utils.readBytesAsUnsignedInt(byteBuffer, superblock.getSizeOfLengths());
                ++n;
            }
        } else {
            this.maxSizes = new int[0];
        }
        this.totalLength = this.type == 2 ? 0L : IntStream.of(this.dimensions).mapToLong(Long::valueOf).reduce(1L, Math::multiplyExact);
    }

    public static DataSpace readDataSpace(ByteBuffer byteBuffer, Superblock superblock) {
        return new DataSpace(byteBuffer, superblock);
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int[] getMaxSizes() {
        return this.maxSizes;
    }

    public boolean isMaxSizesPresent() {
        return this.maxSizesPresent;
    }
}

