/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class FillValueMessage
extends Message {
    private static final int FILL_VALUE_DEFINED_BIT = 5;
    private final int spaceAllocationTime;
    private final int fillValueWriteTime;
    private final boolean fillValueDefined;
    private final ByteBuffer fillValue;

    FillValueMessage(ByteBuffer byteBuffer, BitSet bitSet) {
        super(bitSet);
        byte by = byteBuffer.get();
        if (by == 1 || by == 2) {
            boolean bl;
            this.spaceAllocationTime = byteBuffer.get();
            this.fillValueWriteTime = byteBuffer.get();
            boolean bl2 = bl = byteBuffer.get() == 1;
            if (by == 2 && bl) {
                int n = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                if (n > 0) {
                    this.fillValue = Utils.createSubBuffer(byteBuffer, n);
                    this.fillValueDefined = true;
                } else {
                    this.fillValue = null;
                    this.fillValueDefined = false;
                }
            } else {
                this.fillValue = null;
                this.fillValueDefined = false;
            }
        } else if (by == 3) {
            BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get()});
            this.spaceAllocationTime = Utils.bitsToInt(bitSet2, 0, 2);
            this.fillValueWriteTime = Utils.bitsToInt(bitSet2, 2, 2);
            this.fillValueDefined = bitSet2.get(5);
            if (this.fillValueDefined) {
                int n = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                this.fillValue = Utils.createSubBuffer(byteBuffer, n);
            } else {
                this.fillValue = null;
            }
        } else {
            throw new HdfException("Unrecognized version = " + by);
        }
    }

    public boolean isFillValueDefined() {
        return this.fillValueDefined;
    }

    public int getSpaceAllocationTime() {
        return this.spaceAllocationTime;
    }

    public int getFillValueWriteTime() {
        return this.fillValueWriteTime;
    }

    public ByteBuffer getFillValue() {
        return this.fillValue.asReadOnlyBuffer();
    }
}

