/*
 * Decompiled with CFR 0.152.
 */
package ummisco.gaml.extensions.hecras.skill;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Ole32;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.skills.Skill;
import io.jhdf.HdfFile;
import io.jhdf.api.Dataset;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.lang3.ArrayUtils;
import ummisco.gaml.extensions.hecras.skill.HecRasEngine;

@GamlAnnotations.skill(name="hecrasSkill", concept={"statistic", "skill"})
@GamlAnnotations.doc(value="read hecras data")
public class HecRasSkill
extends Skill {
    public HecRasEngine hrc;

    @GamlAnnotations.action(name="load_hecras", doc={@GamlAnnotations.doc(value="instantiate hecras engine", returns="running hecras engine", examples={@GamlAnnotations.example(value="load_hecras")})})
    public Object load_hecras(IScope iScope) {
        int n = 0;
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        this.hrc = new HecRasEngine();
        iScope.getSimulation().postDisposeAction(iScope2 -> {
            try {
                if (this.hrc != null) {
                    this.hrc.QuitRas();
                    this.hrc.release();
                    Ole32.INSTANCE.CoUninitialize();
                    this.hrc = null;
                }
            }
            catch (Exception exception) {
                iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
                exception.printStackTrace();
            }
            return null;
        });
        return n;
    }

    @GamlAnnotations.action(name="Generate_RasMap", args={@GamlAnnotations.arg(name="filePath", type=4, optional=false, doc={@GamlAnnotations.doc(value="filePath")}), @GamlAnnotations.arg(name="planName", type=4, optional=false, doc={@GamlAnnotations.doc(value="planName")}), @GamlAnnotations.arg(name="terrain", type=4, optional=false, doc={@GamlAnnotations.doc(value="terrain")}), @GamlAnnotations.arg(name="simDate", type=4, optional=false, doc={@GamlAnnotations.doc(value="simDate")}), @GamlAnnotations.arg(name="startHour", type=1, optional=false, doc={@GamlAnnotations.doc(value="startHour")}), @GamlAnnotations.arg(name="endHour", type=1, optional=false, doc={@GamlAnnotations.doc(value="endHour")}), @GamlAnnotations.arg(name="startMin", type=1, optional=false, doc={@GamlAnnotations.doc(value="startMin")}), @GamlAnnotations.arg(name="endMin", type=1, optional=false, doc={@GamlAnnotations.doc(value="endMin")})}, doc={@GamlAnnotations.doc(value="Generate_RasMap hecras", returns="vrf files", examples={@GamlAnnotations.example(value="generateTiff(\r\n\t\t\t\t\"C:\\\\git\\\\gama.experimental\\\\ummisco.gama.extension.hecras\\\\models\\\\GAMA to hecras\\\\HWC\\\\HWC2.rasmap\",\r\n\t\t\t\t\"Plan 04\", \"25JUL2019\", 0, 24, 0, 60)")})})
    public Object primGenerate_RasMap(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            String string = iScope.getStringArg("filePath");
            String string2 = iScope.getStringArg("planName");
            String string3 = iScope.getStringArg("terrain");
            String string4 = iScope.getStringArg("simDate");
            int n2 = iScope.getIntArg("startHour");
            int n3 = iScope.getIntArg("endHour");
            int n4 = iScope.getIntArg("startMin");
            int n5 = iScope.getIntArg("endMin");
            n = this.hrc.generateTiff(string, string2, string3, string4, n2, n3, n4, n5);
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="Project_Open", args={@GamlAnnotations.arg(name="file", type=12, optional=false, doc={@GamlAnnotations.doc(value="project path")})}, doc={@GamlAnnotations.doc(value="open hecras project", returns="opened hecras project", examples={@GamlAnnotations.example(value="Project_Open(\"E:\\Downloads\\HWC\\HelloWorldCoupling.prj\")")})})
    public Object primProject_Open(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            String string = iScope.getStringArg("file");
            n = this.hrc.Project_Open(string);
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="Compute_CurrentPlan", doc={@GamlAnnotations.doc(value="Compute CurrentPlan", returns="Computed CurrentPlan", examples={@GamlAnnotations.example(value="Compute_CurrentPlan()")})})
    public Object primCompute_CurrentPlan(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            n = this.hrc.Compute_CurrentPlan();
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="Compute_HideComputationWindow", doc={@GamlAnnotations.doc(value="Compute_HideComputationWindow", returns="Compute_HideComputationWindow", examples={@GamlAnnotations.example(value="Compute_HideComputationWindow()")})})
    public Object primCompute_HideComputationWindow(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            n = this.hrc.Compute_HideComputationWindow();
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="Project_Close", doc={@GamlAnnotations.doc(value="Project_Close", returns="Project_Close", examples={@GamlAnnotations.example(value="Project_Close()")})})
    public Object primProject_Close(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            n = this.hrc.Project_Close();
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="ExportGIS", doc={@GamlAnnotations.doc(value="ExportGIS", returns="ExportGIS", examples={@GamlAnnotations.example(value="ExportGIS()")})})
    public Object primExportGIS(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            n = this.hrc.ExportGIS();
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="Update_Data", args={@GamlAnnotations.arg(name="num", type=1, optional=false, doc={@GamlAnnotations.doc(value="number step")})}, doc={@GamlAnnotations.doc(value="update data", returns="updated data", examples={@GamlAnnotations.example(value="Update_Data(100)")})})
    public Object primUpdate_Data(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            Integer n2 = iScope.getIntArg("num");
            File file = new File("E:\\Downloads\\HWC\\HelloWorldCoupling.p04.hdf");
            Throwable throwable = null;
            Object var6_8 = null;
            try (HdfFile hdfFile = new HdfFile(file);){
                Dataset dataset = hdfFile.getDatasetByPath("/Results/Unsteady/Output/Output Blocks/Base Output/Unsteady Time Series/2D Flow Areas/Hello 2D Area/Depth");
                float[][] fArray = (float[][])dataset.getData();
                try {
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try (PrintWriter printWriter = new PrintWriter(new FileOutputStream("E:\\git\\hecras_gama_coupling\\includes\\Depth.csv", false));){
                        int n3;
                        int n4 = dataset.getDimensions()[0];
                        int n5 = dataset.getDimensions()[1];
                        float[] fArray2 = new float[(int)dataset.getSize()];
                        int n6 = 0;
                        while (n6 < n4) {
                            n3 = 0;
                            while (n3 < n5) {
                                fArray2[n6 * n5 + n3] = fArray[n6][n3];
                                ++n3;
                            }
                            ++n6;
                        }
                        float[][][] fArrayArray = new float[2000][][];
                        n3 = 0;
                        int n7 = 0;
                        while (n7 < fArray2.length - 800) {
                            fArrayArray[n3] = new float[20][40];
                            int n8 = 0;
                            while (n8 < 20) {
                                int n9 = 0;
                                while (n9 < 40) {
                                    fArrayArray[n3][n8][n9] = fArray2[n7];
                                    ++n7;
                                    ++n9;
                                }
                                ++n8;
                            }
                            ++n3;
                        }
                        printWriter.println(ArrayUtils.toString((Object)fArrayArray[n2]).replace("},{", "\n").replace("{{", "").replace("}}", ""));
                        printWriter.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }

    @GamlAnnotations.action(name="QuitRas", doc={@GamlAnnotations.doc(value="QuitRas", returns="QuitRas", examples={@GamlAnnotations.example(value="QuitRas()")})})
    public Object primQuitRas(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        try {
            n = this.hrc.QuitRas();
            this.hrc.release();
            Ole32.INSTANCE.CoUninitialize();
            this.hrc = null;
        }
        catch (Exception exception) {
            iScope.getGui().getConsole().informConsole(exception.getMessage(), null);
            exception.printStackTrace();
        }
        return n;
    }
}

