/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.imageanalysis.operators;

import boofcv.alg.color.ColorRgb;
import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.alg.enhance.GEnhanceImageOps;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.shapes.ShapeFittingOps;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.PointIndex_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import com.google.common.io.Files;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.experimental.imageanalysis.boofcv.RemovePerspectiveDistortion;
import gama.experimental.imageanalysis.types.PatternBlock;
import gama.experimental.imageanalysis.types.PhysicalBlock;
import gama.experimental.webcam.operators.WebcamOperators;
import gama.experimental.webcam.types.GamaWebcam;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class PatternMatching {
    static double cornerPenalty = 0.25;
    static int minSide = 10;

    private static List<BufferedImage> cropGrid(BufferedImage bufferedImage, int n, int n2, int n3, int n4, float f, float f2) throws IOException {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        int n5 = bufferedImage.getWidth() / n;
        int n6 = bufferedImage.getHeight() / n2;
        int n7 = 0;
        while (n7 < n) {
            int n8 = 0;
            while (n8 < n2) {
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(n7 * n5, n8 * n6, n5, n6);
                bufferedImage2 = PatternMatching.fitCannyBinary(bufferedImage2, n3, n4, f, f2);
                arrayList.add(bufferedImage2);
                ++n8;
            }
            ++n7;
        }
        return arrayList;
    }

    private static BufferedImage fitCannyBinary(BufferedImage bufferedImage, int n, int n2, float f, float f2) {
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        BufferedImage bufferedImage2 = new BufferedImage(grayF32.width, grayF32.height, 1);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        CannyEdge cannyEdge = FactoryEdgeDetectors.canny((int)2, (boolean)false, (boolean)true, GrayF32.class, GrayF32.class);
        cannyEdge.process((ImageGray)grayF32, f, f2, grayU8);
        List list = BinaryImageOps.contourExternal((GrayU8)grayU8, (ConnectRule)ConnectRule.EIGHT);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setStroke(new BasicStroke(2.0f));
        int n3 = bufferedImage.getWidth();
        int n4 = 0;
        int n5 = bufferedImage.getHeight();
        int n6 = 0;
        for (Contour contour : list) {
            for (Point2D_I32 point2D_I32 : contour.external) {
                n3 = Math.min(n3, point2D_I32.getX());
                n5 = Math.min(n5, point2D_I32.getY());
                n4 = Math.max(n4, point2D_I32.getX());
                n6 = Math.max(n6, point2D_I32.getY());
            }
        }
        int n7 = n4 - n;
        int n8 = n3 + n;
        if (n4 - n3 > n) {
            int n9 = 0;
            int n10 = 0;
            for (Contour contour : list) {
                for (Point2D_I32 point2D_I32 : contour.external) {
                    if (point2D_I32.getX() > n8) {
                        ++n9;
                    }
                    if (point2D_I32.getX() >= n7) continue;
                    ++n10;
                }
            }
            if (n10 > n9) {
                n4 = n3 + n;
            } else {
                n3 = n4 - n;
            }
        } else if (n4 - n3 < n) {
            n4 = n3 + n;
        }
        int n11 = n6 - n2;
        int n12 = n5 + n2;
        if (n6 - n5 > n2) {
            int n13 = 0;
            int n14 = 0;
            for (Point2D_I32 point2D_I32 : list) {
                for (Point2D_I32 point2D_I322 : point2D_I32.external) {
                    if (point2D_I322.getY() > n12) {
                        ++n13;
                    }
                    if (point2D_I322.getY() >= n11) continue;
                    ++n14;
                }
            }
            if (n14 > n13) {
                n6 = n5 + n2;
            } else {
                n5 = n6 - n2;
            }
        } else if (n6 - n5 < n2) {
            n6 = n5 + n2;
        }
        return bufferedImage.getSubimage(n3, n5, Math.min(n4 - n3, bufferedImage.getWidth() - n3), Math.min(n6 - n5, bufferedImage.getHeight() - n5));
    }

    public static BufferedImage mirrorImage(BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            int n5 = n2 - 1;
            while (n4 < n2) {
                int n6 = bufferedImage.getRGB(n4, n3);
                bufferedImage2.setRGB(n5, n3, n6);
                ++n4;
                --n5;
            }
            ++n3;
        }
        return bufferedImage2;
    }

    public static IList<PhysicalBlock> classifyCode(IScope iScope, List<BufferedImage> list, IList<PatternBlock> iList, double d, double d2, int n, int n2, double d3, double d4, double d5, double d6, float f, boolean bl, boolean bl2) {
        File file;
        int n3 = 0;
        int n4 = 0;
        Envelope3D envelope3D = iScope.getSimulation().getGeometry().getEnvelope();
        double d7 = envelope3D.getWidth() / (double)n;
        double d8 = envelope3D.getHeight() / (double)n2;
        d *= (double)f;
        d2 *= (double)f;
        File file2 = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\subblocks");
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\blocks")).exists()) {
            file.mkdir();
        }
        IList iList2 = GamaListFactory.create();
        for (PatternBlock patternBlock : iList) {
            n3 = Math.max(n3, patternBlock.getMatrix().numRows);
            n4 = Math.max(n4, patternBlock.getMatrix().numCols);
        }
        try {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (BufferedImage bufferedImage : list) {
                GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n3, n4);
                int n9 = bufferedImage.getWidth() / n4;
                int n10 = bufferedImage.getHeight() / n3;
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = 0;
                    while (n12 < n3) {
                        BufferedImage bufferedImage2 = bufferedImage.getSubimage(Math.min(n11 * n9, bufferedImage.getWidth() - n9), Math.min(n12 * n10, bufferedImage.getHeight() - n10), n9, n10);
                        Planar planar = (Planar)ConvertBufferedImage.convertFrom((BufferedImage)bufferedImage2, (boolean)true, (ImageType)ImageType.pl((int)3, GrayU8.class));
                        GrayU8 grayU8 = new GrayU8(planar.width, planar.height);
                        ColorRgb.rgbToGray_Weighted((ImageMultiBand)planar, (ImageGray)grayU8);
                        ConvertBufferedImage.convertTo((GrayU8)grayU8, (BufferedImage)bufferedImage2);
                        RescaleOp rescaleOp = new RescaleOp(f, 0.0f, null);
                        rescaleOp.filter(bufferedImage2, bufferedImage2);
                        if (bl) {
                            File file3 = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\subblocks\\image_" + n7 + ".jpg");
                            ImageIO.write((RenderedImage)bufferedImage2, "jpg", file3);
                            System.out.println("image_" + n7 + " -> " + PatternMatching.getBlackIntensity(bufferedImage2) + " i: " + n11 + " j: " + n12 + " black:  " + PatternMatching.isBlack(bufferedImage2, d, d2, bl2));
                        }
                        if (PatternMatching.isBlack(bufferedImage2, d, d2, bl2)) {
                            gamaIntMatrix.set(iScope, n12, n11, 0);
                        } else {
                            gamaIntMatrix.set(iScope, n12, n11, 1);
                        }
                        ++n7;
                        ++n12;
                    }
                    ++n11;
                }
                PhysicalBlock physicalBlock = new PhysicalBlock();
                iList2.add((Object)physicalBlock);
                if (bl) {
                    File file4 = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\blocks\\image_" + n8 + ".jpg");
                    ImageIO.write((RenderedImage)bufferedImage, "jpg", file4);
                    System.out.println("image_" + n8 + " -> l : " + gamaIntMatrix.toString() + "  x_g: " + n5 + "  y_g: " + n5);
                }
                for (PatternBlock patternBlock : iList) {
                    if (!patternBlock.getMatrix().equals((Object)gamaIntMatrix)) continue;
                    physicalBlock.setPattern(patternBlock);
                    break;
                }
                ++n8;
                physicalBlock.setShape((IShape)new GamaPoint(((double)n5 * d7 + d7 / 2.0) * d5 + d3, ((double)n6 * d8 + d8 / 2.0) * d6 + d4));
                if (++n6 < n2) continue;
                n6 = 0;
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"crop_image"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="crop an image")
    public static String imageCropping(IScope iScope, String string, IShape iShape, String string2, IShape iShape2) {
        File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string2, (boolean)true));
        if (file == null || file.getName().trim().isEmpty()) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string2), (IScope)iScope), (boolean)true);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string2), (IScope)iScope), (boolean)true);
        }
        if (bufferedImage == null) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string2), (IScope)iScope), (boolean)true);
        }
        Envelope3D envelope3D = iShape2 == null ? iScope.getSimulation().getGeometry().getEnvelope() : iShape2.getEnvelope();
        double d = (double)bufferedImage.getWidth() / envelope3D.getWidth();
        double d2 = (double)bufferedImage.getHeight() / envelope3D.getHeight();
        Envelope3D envelope3D2 = iShape.getEnvelope();
        BufferedImage bufferedImage2 = bufferedImage.getSubimage((int)Math.round((envelope3D2.getMinX() - envelope3D.getMinX()) * d), (int)Math.round((envelope3D2.getMinY() - envelope3D.getMinY()) * d2), (int)Math.round(envelope3D2.getWidth() * d), (int)Math.round(envelope3D2.getHeight() * d2));
        File file2 = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false));
        try {
            String string3 = Files.getFileExtension((String)file2.getAbsolutePath());
            ImageIO.write((RenderedImage)bufferedImage2, string3, file2);
        }
        catch (IOException iOException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when writting file " + String.valueOf(file2) + ": " + String.valueOf(iOException)), (IScope)iScope), (boolean)true);
        }
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return null;
    }

    private static Point2D_F64 toPoint2D(GamaPoint gamaPoint, double d, double d2) {
        return new Point2D_F64(gamaPoint.x * d, gamaPoint.y * d2);
    }

    @GamlAnnotations.operator(value={"remove_perspective"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="remove the perspective from an image using 4 reference points (top-left, top-right, bottom-right, bottom-left)")
    public static String removePerspective(IScope iScope, String string, String string2, IList<GamaPoint> iList) {
        BufferedImage bufferedImage = PatternMatching.removeDistortion(iScope, iList, PatternMatching.getBufferedImage(iScope, string2));
        File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false));
        try {
            bufferedImage = PatternMatching.mirrorImage(bufferedImage);
            String string3 = Files.getFileExtension((String)file.getAbsolutePath());
            ImageIO.write((RenderedImage)bufferedImage, string3, file);
        }
        catch (IOException iOException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when writting file " + String.valueOf(file) + ": " + String.valueOf(iOException)), (IScope)iScope), (boolean)true);
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static BufferedImage getBufferedImage(IScope iScope, String string) {
        File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)true));
        if (file == null || file.getName().trim().isEmpty()) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        if (bufferedImage == null) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        return bufferedImage;
    }

    public static BufferedImage removeDistortion(IScope iScope, List<GamaPoint> list, BufferedImage bufferedImage) {
        RemovePerspectiveDistortion<Planar> removePerspectiveDistortion;
        if (list.size() != 4) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)"4 points have to be defined (top-left, top-right, bottom-right, bottom-left)", (IScope)iScope), (boolean)true);
        }
        Envelope3D envelope3D = iScope.getSimulation().getGeometry().getEnvelope();
        double d = (double)bufferedImage.getWidth() / envelope3D.getWidth();
        double d2 = (double)bufferedImage.getHeight() / envelope3D.getHeight();
        Planar planar = ConvertBufferedImage.convertFromPlanar((BufferedImage)bufferedImage, null, (boolean)true, GrayF32.class);
        Point2D_F64 point2D_F64 = PatternMatching.toPoint2D(list.get(0), d, d2);
        Point2D_F64 point2D_F642 = PatternMatching.toPoint2D(list.get(1), d, d2);
        Point2D_F64 point2D_F643 = PatternMatching.toPoint2D(list.get(2), d, d2);
        Point2D_F64 point2D_F644 = PatternMatching.toPoint2D(list.get(3), d, d2);
        int n = (int)(d * (list.get((int)1).x - list.get((int)0).x));
        int n2 = (int)(d2 * (list.get((int)2).y - list.get((int)0).y));
        if (planar.getNumBands() > 3) {
            planar.reshape(planar.width, planar.height, 3);
        }
        if (!(removePerspectiveDistortion = new RemovePerspectiveDistortion<Planar>(n, n2, ImageType.pl((int)3, GrayF32.class))).apply(planar, point2D_F64, point2D_F642, point2D_F643, point2D_F644)) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)"Problem with distortion computation", (IScope)iScope), (boolean)true);
        }
        Planar planar2 = (Planar)removePerspectiveDistortion.getOutput();
        return ConvertBufferedImage.convertTo_F32((Planar)planar2, null, (boolean)true);
    }

    public static double getBlackIntensity(BufferedImage bufferedImage) {
        int n = 0;
        int n2 = bufferedImage.getHeight() * bufferedImage.getWidth();
        int n3 = bufferedImage.getMinX();
        while (n3 < bufferedImage.getWidth()) {
            int n4 = bufferedImage.getMinTileY();
            while (n4 < bufferedImage.getHeight()) {
                n += bufferedImage.getRGB(n3, n4) & 0xFF;
                ++n4;
            }
            ++n3;
        }
        return (0.0 + (double)n) / (0.0 + (double)n2);
    }

    public static boolean isBlackNumberCanny(BufferedImage bufferedImage, float f, float f2) {
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        new BufferedImage(grayF32.width, grayF32.height, 1);
        CannyEdge cannyEdge = FactoryEdgeDetectors.canny((int)2, (boolean)true, (boolean)true, GrayF32.class, GrayF32.class);
        cannyEdge.process((ImageGray)grayF32, 0.1f, 0.3f, null);
        List list = cannyEdge.getContours();
        double d = 0.0;
        for (EdgeContour edgeContour : list) {
            for (EdgeSegment edgeSegment : edgeContour.segments) {
                double d2 = 0.0;
                List list2 = ShapeFittingOps.fitPolygon((List)edgeSegment.points, (boolean)false, (int)minSide, (double)cornerPenalty);
                if (list2.isEmpty()) continue;
                PointIndex_I32 pointIndex_I32 = (PointIndex_I32)list2.get(0);
                int n = 1;
                while (n < list2.size()) {
                    PointIndex_I32 pointIndex_I322 = (PointIndex_I32)list2.get(n);
                    d2 += pointIndex_I322.distance((Point2D_I32)pointIndex_I32);
                    pointIndex_I32 = pointIndex_I322;
                    ++n;
                }
                d += d2;
            }
        }
        return d < 70.0;
    }

    public static BufferedImage improveImage(BufferedImage bufferedImage) {
        Planar planar = (Planar)ConvertBufferedImage.convertFrom((BufferedImage)bufferedImage, (boolean)true, (ImageType)ImageType.PL_U8);
        Planar planar2 = (Planar)planar.createSameShape();
        GEnhanceImageOps.sharpen8((ImageBase)planar, (ImageBase)planar2);
        bufferedImage = ConvertBufferedImage.convertTo((ImageBase)planar2, null, (boolean)true);
        planar = (Planar)ConvertBufferedImage.convertFrom((BufferedImage)bufferedImage, (boolean)true, (ImageType)ImageType.PL_U8);
        planar2 = (Planar)planar.createSameShape();
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n = 0;
        while (n < planar.getNumBands()) {
            ImageStatistics.histogram((GrayU8)((GrayU8)planar.getBand(n)), (int)0, (int[])nArray);
            EnhanceImageOps.equalize((int[])nArray, (int[])nArray2);
            EnhanceImageOps.applyTransform((GrayU8)((GrayU8)planar.getBand(n)), (int[])nArray2, (GrayU8)((GrayU8)planar2.getBand(n)));
            ++n;
        }
        GEnhanceImageOps.equalizeLocal((ImageBase)planar, (int)50, (ImageBase)planar2, (int)256, null);
        bufferedImage = ConvertBufferedImage.convertTo((ImageBase)planar2, null, (boolean)true);
        return bufferedImage;
    }

    public static boolean isBlack(BufferedImage bufferedImage, double d, double d2, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (bl) {
            bufferedImage = PatternMatching.improveImage(bufferedImage);
        }
        int n3 = bufferedImage.getMinX();
        while (n3 < bufferedImage.getWidth()) {
            int n4 = bufferedImage.getMinTileY();
            while (n4 < bufferedImage.getHeight()) {
                int n5 = bufferedImage.getRGB(n3, n4) & 0xFF;
                if ((double)n5 <= d) {
                    ++n;
                }
                if ((double)n5 >= d2) {
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        return n >= n2;
    }

    private static List<Double> computeThresholdBlackIntensity(IScope iScope, BufferedImage bufferedImage, IShape iShape, IShape iShape2, double d, boolean bl, boolean bl2) {
        Serializable serializable;
        Object object;
        Envelope3D envelope3D = iScope.getSimulation().getGeometry().getEnvelope();
        Envelope3D envelope3D2 = iShape.getEnvelope();
        if (bl2) {
            bufferedImage = PatternMatching.improveImage(bufferedImage);
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage((int)(envelope3D2.getMinX() / envelope3D.getWidth() * (double)bufferedImage.getWidth()), (int)(envelope3D2.getMinY() / envelope3D.getHeight() * (double)bufferedImage.getHeight()), (int)(envelope3D2.getWidth() / envelope3D.getWidth() * (double)bufferedImage.getWidth()), (int)(envelope3D2.getHeight() / envelope3D.getHeight() * (double)bufferedImage.getHeight()));
        double d2 = PatternMatching.getBlackIntensity(bufferedImage2);
        if (bl) {
            object = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\image_black.jpg");
            try {
                ImageIO.write((RenderedImage)bufferedImage2, "jpg", (File)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = iShape2.getEnvelope();
        BufferedImage bufferedImage3 = bufferedImage.getSubimage((int)(object.getMinX() / envelope3D.getWidth() * (double)bufferedImage.getWidth()), (int)(object.getMinY() / envelope3D.getHeight() * (double)bufferedImage.getHeight()), (int)(object.getWidth() / envelope3D.getWidth() * (double)bufferedImage.getWidth()), (int)(object.getHeight() / envelope3D.getHeight() * (double)bufferedImage.getHeight()));
        double d3 = PatternMatching.getBlackIntensity(bufferedImage3);
        if (bl) {
            serializable = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\image_white.jpg");
            try {
                ImageIO.write((RenderedImage)bufferedImage3, "jpg", (File)serializable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        d3 /= d;
        d2 *= d;
        if (bl) {
            System.out.println("Black Intensity: " + d2 + " - White Intensity:" + d3);
        }
        serializable = new ArrayList();
        serializable.add(d2);
        serializable.add(d3);
        return serializable;
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=false, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the image")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, String string, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, int n3, int n4, IShape iShape, IShape iShape2, IShape iShape3) {
        return PatternMatching.detecBlocks(iScope, string, iList, iList2, n3, n4, iShape, iShape2, iShape3, 1.0, (double)0.1f, 0.5, 2.0, false, false);
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=true, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the image contained in the matrix")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, IMatrix<Integer> iMatrix, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, iMatrix);
        return PatternMatching.detecBlocks(iScope, bufferedImage, iList, iList2, n, n2, iShape, iShape2, iShape3, d, d2, d3, d4, bl, bl2);
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=false, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the webcam - autoclose or not the webcam after")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, GamaWebcam gamaWebcam, boolean bl, boolean bl2, boolean bl3, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3) {
        BufferedImage bufferedImage = WebcamOperators.CamShotAct((IScope)iScope, (GamaWebcam)gamaWebcam, null, (boolean)bl, (boolean)bl2, (boolean)bl3);
        return PatternMatching.detecBlocks(iScope, bufferedImage, iList, iList2, n, n2, iShape, iShape2, iShape3, 1.0, (double)0.1f, 0.5, 2.0, false, false);
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=false, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the webcam - autoclose or not the webcam after")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl, boolean bl2, boolean bl3, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3) {
        BufferedImage bufferedImage = WebcamOperators.CamShotAct((IScope)iScope, (GamaWebcam)gamaWebcam, gamaPair, (boolean)bl, (boolean)bl2, (boolean)bl3);
        return PatternMatching.detecBlocks(iScope, bufferedImage, iList, iList2, n, n2, iShape, iShape2, iShape3, 1.0, (double)0.1f, 0.5, 2.0, false, false);
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=false, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the webcam - autoclose or not the webcam after")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl, boolean bl2, boolean bl3, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3, double d, double d2, double d3, double d4, boolean bl4, boolean bl5) {
        BufferedImage bufferedImage = WebcamOperators.CamShotAct((IScope)iScope, (GamaWebcam)gamaWebcam, gamaPair, (boolean)bl, (boolean)bl2, (boolean)bl3);
        return PatternMatching.detecBlocks(iScope, bufferedImage, iList, iList2, n, n2, iShape, iShape2, iShape3, d, d2, d3, d4, bl4, bl5);
    }

    @GamlAnnotations.operator(value={"detect_blocks"}, can_be_const=false, category={"image"})
    @GamlAnnotations.doc(value="detect the block from the image")
    public static IList<PhysicalBlock> detecBlocks(IScope iScope, String string, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        BufferedImage bufferedImage = PatternMatching.getBufferedImage(iScope, string);
        return PatternMatching.detecBlocks(iScope, bufferedImage, iList, iList2, n, n2, iShape, iShape2, iShape3, d, d2, d3, d4, bl, bl2);
    }

    public static IList<PhysicalBlock> detecBlocks(IScope iScope, BufferedImage bufferedImage, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, IShape iShape, IShape iShape2, IShape iShape3, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        try {
            Object object;
            if (bl && !((File)(object = new File(iScope.getModel().getProjectPath() + "\\models\\generated"))).exists()) {
                ((File)object).mkdir();
            }
            object = iScope.getSimulation().getGeometry().getEnvelope();
            int n3 = (int)(iShape3.getWidth() / object.getWidth() * (double)bufferedImage.getWidth());
            int n4 = (int)(iShape3.getHeight() / object.getHeight() * (double)bufferedImage.getHeight());
            List<Double> list = PatternMatching.computeThresholdBlackIntensity(iScope, bufferedImage, iShape, iShape2, d, bl, bl2);
            double d5 = list.get(0);
            double d6 = list.get(1);
            return PatternMatching.codeDetectBlocksFct(iScope, bufferedImage, iList, iList2, n, n2, d5, d6, n3, n4, (float)d2, (float)d3, (float)d4, bl, bl2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static IList<PhysicalBlock> codeDetectBlocksFct(IScope iScope, BufferedImage bufferedImage, IList<PatternBlock> iList, IList<GamaPoint> iList2, int n, int n2, double d, double d2, int n3, int n4, float f, float f2, float f3, boolean bl, boolean bl2) throws IOException {
        Object object;
        BufferedImage bufferedImage2;
        BufferedImage bufferedImage3 = bufferedImage2 = iList2 != null && iList2.size() == 4 ? PatternMatching.removeDistortion(iScope, iList2, bufferedImage) : bufferedImage;
        if (bl) {
            object = new File(iScope.getModel().getProjectPath() + "\\models\\generated\\image_distorsion.jpg");
            ImageIO.write((RenderedImage)bufferedImage2, "jpg", (File)object);
        }
        object = PatternMatching.cropGrid(bufferedImage2, n, n2, n3, n4, f, f2);
        Envelope3D envelope3D = iScope.getSimulation().getGeometry().getEnvelope();
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = 0.0;
        double d6 = 0.0;
        if (iList2 != null && iList2.size() == 4) {
            for (GamaPoint gamaPoint : iList2) {
                d3 = Math.min(d3, gamaPoint.x);
                d5 = Math.max(d5, gamaPoint.x);
                d4 = Math.min(d4, gamaPoint.y);
                d6 = Math.max(d6, gamaPoint.y);
            }
        } else {
            d5 = envelope3D.getWidth();
            d6 = envelope3D.getHeight();
        }
        return PatternMatching.classifyCode(iScope, (List<BufferedImage>)object, iList, d, d2, n, n2, d3, d4, (d5 - d3) / envelope3D.getWidth(), (d6 - d4) / envelope3D.getHeight(), f3, bl, bl2);
    }

    private static IMatrix matrixValueFromImage(IScope iScope, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = bufferedImage;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                gamaIntMatrix.set(iScope, n3, n4, (Object)bufferedImage2.getRGB(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return gamaIntMatrix;
    }
}

