/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.launchpad.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.experimental.launchpad.skills.LaunchPadEventLayer;
import gama.gaml.skills.Skill;
import net.thecodersbreakfast.lp4j.api.BackBufferOperation;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Color;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="buttonPressed", type=4, doc={@GamlAnnotations.doc(value="get button pressed name")}), @GamlAnnotations.variable(name="padPressed", type=7, doc={@GamlAnnotations.doc(value="get pad pressed name")})})
@GamlAnnotations.doc(value="The launchpad skill is intended to interact with a simulation using a launchpad interface")
@GamlAnnotations.skill(name="launchpadskill", concept={"layer"})
public class LaunchPadSkill
extends Skill {
    @GamlAnnotations.getter(value="buttonPressed")
    public String getButtonPressed() {
        String string = LaunchPadEventLayer.pressedButton != null ? LaunchPadEventLayer.pressedButton.name() : "NULL";
        return string;
    }

    @GamlAnnotations.getter(value="padPressed")
    public GamaPoint getPadPressed() {
        GamaPoint gamaPoint = new GamaPoint((double)LaunchPadEventLayer.pressedPad.getX(), (double)LaunchPadEventLayer.pressedPad.getY());
        return gamaPoint;
    }

    @GamlAnnotations.action(name="resetPad", doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do resetPad;")}, value="reset the pad")})
    public void resetPad(IScope iScope) throws GamaRuntimeException {
        if (LaunchPadEventLayer.client != null) {
            LaunchPadEventLayer.client.reset();
        }
    }

    @GamlAnnotations.action(name="updateDisplay", doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do updateDisplay;")}, value="update GAMA Display")})
    public void updateDisplay(IScope iScope) throws GamaRuntimeException {
        GAMA.getExperiment().refreshAllOutputs();
    }

    @GamlAnnotations.action(name="setPadLight", args={@GamlAnnotations.arg(name="color", type=4, optional=false, doc={@GamlAnnotations.doc(value="Color of the pad (as a string)")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do setPadLight color: #red;")}, value="set the color of the pad pressed")})
    public void setPadLight(IScope iScope) throws GamaRuntimeException {
        String string;
        String string2 = string = iScope.hasArg("color") ? (String)iScope.getArg("color", 4) : "black";
        if (LaunchPadEventLayer.pressedPad != null) {
            if (string.equals("brown")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.BROWN, BackBufferOperation.NONE);
            }
            if (string.equals("black")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.BLACK, BackBufferOperation.NONE);
            }
            if (string.equals("green")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.GREEN, BackBufferOperation.NONE);
            }
            if (string.equals("darkgreen")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.DARKGREEN, BackBufferOperation.NONE);
            }
            if (string.equals("orange")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.ORANGE, BackBufferOperation.NONE);
            }
            if (string.equals("red")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.RED, BackBufferOperation.NONE);
            }
            if (string.equals("darkred")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.DARKRED, BackBufferOperation.NONE);
            }
            if (string.equals("yellow")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.YELLOW, BackBufferOperation.NONE);
            }
            if (string.equals("lightyellow")) {
                LaunchPadEventLayer.client.setPadLight(LaunchPadEventLayer.pressedPad, Color.LIGHTYELLOW, BackBufferOperation.NONE);
            }
        }
    }

    @GamlAnnotations.action(name="setButtonLight", args={@GamlAnnotations.arg(name="colors", type=5, optional=false, doc={@GamlAnnotations.doc(value="Color of the top button ")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do setButtonLight colors: colors;")}, value="set the color of the top buttons")})
    public void setButtonLight(IScope iScope) throws GamaRuntimeException {
        IList iList = (IList)iScope.getArg("colors", 5);
        if (LaunchPadEventLayer.client != null) {
            LaunchPadEventLayer.client.setButtonLight(Button.UP, LaunchPadEventLayer.colorMap.get(iList.get(0)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.DOWN, LaunchPadEventLayer.colorMap.get(iList.get(1)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.LEFT, LaunchPadEventLayer.colorMap.get(iList.get(2)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.RIGHT, LaunchPadEventLayer.colorMap.get(iList.get(3)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.SESSION, LaunchPadEventLayer.colorMap.get(iList.get(4)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.USER_1, LaunchPadEventLayer.colorMap.get(iList.get(5)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.USER_2, LaunchPadEventLayer.colorMap.get(iList.get(6)), BackBufferOperation.NONE);
            LaunchPadEventLayer.client.setButtonLight(Button.MIXER, LaunchPadEventLayer.colorMap.get(iList.get(7)), BackBufferOperation.NONE);
        }
    }
}

