/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.api;

public enum Button {
    UP(0, true),
    DOWN(1, true),
    LEFT(2, true),
    RIGHT(3, true),
    SESSION(4, true),
    USER_1(5, true),
    USER_2(6, true),
    MIXER(7, true),
    VOL(0, false),
    PAN(1, false),
    SND_A(2, false),
    SND_B(3, false),
    STOP(4, false),
    TRACK_ON(5, false),
    SOLO(6, false),
    ARM(7, false);

    public static final int MIN_COORD = 0;
    public static final int MAX_COORD = 7;
    public static final Button[] BUTTONS_TOP;
    public static final Button[] BUTTONS_RIGHT;
    private final int coordinate;
    private final boolean topButton;

    static {
        BUTTONS_TOP = new Button[]{UP, DOWN, LEFT, RIGHT, SESSION, USER_1, USER_2, MIXER};
        BUTTONS_RIGHT = new Button[]{VOL, PAN, SND_A, SND_B, STOP, TRACK_ON, SOLO, ARM};
    }

    private static Button at(boolean bl, int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException(String.format("Invalid button coordinates : %d. Value must be between %d and %d inclusive.", n, 0, 7));
        }
        return bl ? BUTTONS_TOP[n] : BUTTONS_RIGHT[n];
    }

    public static Button atTop(int n) {
        return Button.at(true, n);
    }

    public static Button atRight(int n) {
        return Button.at(false, n);
    }

    private Button(int n2, boolean bl) {
        this.coordinate = n2;
        this.topButton = bl;
    }

    public int getCoordinate() {
        return this.coordinate;
    }

    public boolean isTopButton() {
        return this.topButton;
    }

    public boolean isRightButton() {
        return !this.topButton;
    }

    public String toString() {
        return String.format("Button[%s(%s,%d)]", this.name(), this.topButton ? "top" : "right", this.coordinate);
    }
}

