/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.emulator;

import java.util.concurrent.CountDownLatch;
import net.thecodersbreakfast.lp4j.api.BackBufferOperation;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Color;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LaunchpadListenerAdapter;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.midi.MidiDeviceConfiguration;
import net.thecodersbreakfast.lp4j.midi.MidiLaunchpad;

public class Example {
    private static CountDownLatch stop = new CountDownLatch(1);

    public static void main(String[] stringArray) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MidiLaunchpad midiLaunchpad = new MidiLaunchpad(MidiDeviceConfiguration.autodetect());){
            LaunchpadClient launchpadClient = midiLaunchpad.getClient();
            MyListener myListener = new MyListener(launchpadClient);
            midiLaunchpad.setListener(myListener);
            launchpadClient.reset();
            launchpadClient.setButtonLight(Button.STOP, Color.RED, BackBufferOperation.NONE);
            stop.await();
            launchpadClient.reset();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class MyListener
    extends LaunchpadListenerAdapter {
        private final LaunchpadClient client;

        public MyListener(LaunchpadClient launchpadClient) {
            this.client = launchpadClient;
        }

        @Override
        public void onPadPressed(Pad pad, long l) {
            this.client.setPadLight(pad, Color.YELLOW, BackBufferOperation.NONE);
            System.out.println("p" + pad.getX() + " " + pad.getY());
        }

        @Override
        public void onPadReleased(Pad pad, long l) {
            this.client.setPadLight(pad, Color.BLACK, BackBufferOperation.NONE);
            System.out.println("p" + pad.getX() + " " + pad.getY());
        }

        @Override
        public void onButtonReleased(Button button, long l) {
            this.client.setButtonLight(button, Color.BLACK, BackBufferOperation.NONE);
            switch (button) {
                case STOP: {
                    stop.countDown();
                    break;
                }
            }
        }
    }
}

