/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;

public class MidiDeviceConfiguration {
    public static final String DEVICE_SIGNATURE = "Launchpad Mini";
    private final MidiDevice inputDevice;
    private final MidiDevice outputDevice;

    public static MidiDeviceConfiguration autodetect() throws MidiUnavailableException {
        MidiDevice midiDevice = MidiDeviceConfiguration.autodetectInputDevice();
        MidiDevice midiDevice2 = MidiDeviceConfiguration.autodetectOutputDevice();
        return new MidiDeviceConfiguration(midiDevice, midiDevice2);
    }

    public MidiDeviceConfiguration(MidiDevice midiDevice, MidiDevice midiDevice2) {
        this.inputDevice = midiDevice;
        this.outputDevice = midiDevice2;
    }

    public MidiDevice getInputDevice() {
        return this.inputDevice;
    }

    public MidiDevice getOutputDevice() {
        return this.outputDevice;
    }

    public static MidiDevice autodetectOutputDevice() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray;
        MidiDevice.Info[] infoArray2 = infoArray = MidiSystem.getMidiDeviceInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MidiDevice midiDevice;
            MidiDevice.Info info = infoArray2[n2];
            if ((info.getDescription().contains(DEVICE_SIGNATURE) || info.getName().contains(DEVICE_SIGNATURE)) && (midiDevice = MidiSystem.getMidiDevice(info)).getMaxReceivers() == -1) {
                return midiDevice;
            }
            ++n2;
        }
        return null;
    }

    public static MidiDevice autodetectInputDevice() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray;
        MidiDevice.Info[] infoArray2 = infoArray = MidiSystem.getMidiDeviceInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MidiDevice.Info info = infoArray2[n2];
            if (info.getDescription().contains(DEVICE_SIGNATURE) || info.getName().contains(DEVICE_SIGNATURE)) {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (midiDevice.getMaxTransmitters() == -1) {
                    return midiDevice;
                }
                midiDevice.close();
            }
            ++n2;
        }
        return null;
    }
}

