/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi.protocol;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.thecodersbreakfast.lp4j.api.LaunchpadException;
import net.thecodersbreakfast.lp4j.midi.protocol.MidiProtocolListener;

public class DefaultMidiProtocolReceiver
implements Receiver {
    private MidiProtocolListener midiProtocolListener;

    public DefaultMidiProtocolReceiver(MidiProtocolListener midiProtocolListener) {
        if (midiProtocolListener == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        this.midiProtocolListener = midiProtocolListener;
    }

    @Override
    public void send(MidiMessage midiMessage, long l) {
        if (!(midiMessage instanceof ShortMessage)) {
            throw new LaunchpadException("Unknown event : " + String.valueOf(midiMessage));
        }
        this.handleShortMessage((ShortMessage)midiMessage, l);
    }

    protected void handleShortMessage(ShortMessage shortMessage, long l) {
        int n = shortMessage.getStatus();
        int n2 = shortMessage.getData1();
        int n3 = shortMessage.getData2();
        if (n == 144) {
            this.handleNoteOnMessage(n2, n3, l);
        } else if (n == 176) {
            this.handleControlChangeMessage(n2, n3, l);
        } else {
            throw new LaunchpadException("Unknown event : " + String.valueOf(shortMessage));
        }
    }

    protected void handleNoteOnMessage(int n, int n2, long l) {
        if (n2 == 0) {
            this.midiProtocolListener.onNoteOff(n, l);
        } else {
            this.midiProtocolListener.onNoteOn(n, l);
        }
    }

    protected void handleControlChangeMessage(int n, int n2, long l) {
        if (n == 0 && n2 == 3) {
            this.midiProtocolListener.onTextScrolled(l);
        } else if (n2 == 0) {
            this.midiProtocolListener.onButtonOff(n, l);
        } else {
            this.midiProtocolListener.onButtonOn(n, l);
        }
    }

    @Override
    public void close() {
    }
}

