/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.markdown.jobs;

import gama.experimental.markdown.markdownSyntactic.IParser;
import gama.experimental.markdown.markdownSyntactic.LightModel;
import gama.experimental.markdown.markdownSyntactic.MarkdownModelDocumentor;
import gama.experimental.markdown.markdownSyntactic.MarkdownTools;
import gama.ui.navigator.view.contents.WrappedFolder;
import gama.ui.navigator.view.contents.WrappedGamaFile;
import gama.ui.navigator.view.contents.WrappedProject;
import gama.ui.navigator.view.contents.WrappedResource;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public abstract class JobDocumentation
extends WorkspaceJob {
    public String directory;
    Map<String, String> speciesLink = new HashMap<String, String>();
    Map<String, String> experimentsLink = new HashMap<String, String>();
    ArrayList<String> modelsDone = new ArrayList();
    public String indexPath;

    public JobDocumentation(String string) {
        super(IParser.JOB_NAME);
        this.directory = string;
        this.indexPath = string + File.separator + IParser.MARKDOWN_LABEL_INDEX + ".md";
    }

    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
        return Status.OK_STATUS;
    }

    public void generateForWrappedResource(WrappedResource<?, ?> wrappedResource) {
        IPath iPath = ((IProject)wrappedResource.getProject().getResource()).getLocation();
        IPath iPath2 = wrappedResource.getResource().getLocation();
        IPath iPath3 = iPath2.makeRelativeTo(iPath);
        if (wrappedResource instanceof WrappedFolder || wrappedResource instanceof WrappedProject) {
            Object[] objectArray;
            File file = new File(this.directory + File.separator + String.valueOf(iPath3));
            if (!Files.exists(file.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(file.toPath(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            Object[] objectArray2 = objectArray = (Object[])wrappedResource.getNavigatorChildren().clone();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object instanceof WrappedResource && ((WrappedResource)object).countModels() > 0) {
                    this.generateForWrappedResource((WrappedResource)object);
                }
                ++n2;
            }
            objectArray = null;
        } else if (wrappedResource instanceof WrappedGamaFile) {
            WrappedGamaFile wrappedGamaFile = (WrappedGamaFile)wrappedResource;
            this.generateForWrappedGamaFile(wrappedGamaFile);
            wrappedGamaFile = null;
        }
    }

    public void dispose() {
        this.experimentsLink = null;
        this.speciesLink = null;
        this.modelsDone = null;
    }

    public void generateIndex() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MarkdownTools.addHeader(IParser.MARKDOWN_LABEL_INDEX));
        stringBuilder.append(MarkdownTools.goBeginLine());
        stringBuilder.append(MarkdownTools.addLine());
        stringBuilder.append(MarkdownTools.goBeginLine());
        stringBuilder.append(MarkdownTools.addSubHeader(IParser.MARKDOWN_LABEL_SPECIES + " (" + this.speciesLink.keySet().size() + ")"));
        ArrayList<String> arrayList = new ArrayList<String>(this.speciesLink.keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        for (String object22 : arrayList) {
            stringBuilder.append(MarkdownTools.goBeginLine());
            stringBuilder.append(MarkdownTools.addLink(object22, this.speciesLink.get(object22)));
        }
        arrayList = null;
        stringBuilder.append(MarkdownTools.goBeginLine());
        stringBuilder.append(MarkdownTools.goBeginLine());
        stringBuilder.append(MarkdownTools.addLine());
        stringBuilder.append(MarkdownTools.goBeginLine());
        stringBuilder.append(MarkdownTools.addSubHeader(IParser.MARKDOWN_LABEL_EXPERIMENTS + " (" + this.experimentsLink.keySet().size() + ")"));
        ArrayList<String> arrayList2 = new ArrayList<String>(this.experimentsLink.keySet());
        Collections.sort(arrayList2, String.CASE_INSENSITIVE_ORDER);
        for (Object object : arrayList2) {
            stringBuilder.append(MarkdownTools.goBeginLine());
            stringBuilder.append(MarkdownTools.addLink((String)object, this.experimentsLink.get(object)));
        }
        Object var3_8 = null;
        try {
            Object object;
            object = null;
            Iterator iterator = null;
            try (FileWriter fileWriter = new FileWriter(this.indexPath);){
                fileWriter.write(stringBuilder.toString());
                fileWriter.flush();
                stringBuilder = null;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void generateForWrappedGamaFile(WrappedGamaFile wrappedGamaFile) {
        IPath iPath;
        Object object;
        LightModel lightModel;
        Object object322;
        Map map = GamlResourceIndexer.allImportsOf((URI)URI.createURI((String)((IFile)wrappedGamaFile.getResource()).getLocationURI().toString()));
        for (Object object322 : map.keySet()) {
            Object object2;
            if (this.modelsDone.contains(object322.toString())) continue;
            this.modelsDone.add(object322.toString());
            lightModel = new LightModel((URI)object322);
            Path object22 = new Path(object322.toFileString().replace("file:", ""));
            object = object22.makeRelativeTo((IPath)new Path(this.indexPath));
            for (String string : lightModel.speciesLink.keySet()) {
                object2 = lightModel.speciesLink.get(string);
                object2 = FilenameUtils.removeExtension((String)object.toString().replaceFirst(".." + File.separator, "").replaceFirst(".." + File.separator, "")) + ".md#" + (String)object2;
                this.speciesLink.put(string, (String)object2);
            }
            for (String string : lightModel.experimentsLink.keySet()) {
                object2 = lightModel.experimentsLink.get(string);
                object2 = FilenameUtils.removeExtension((String)object.toString().replaceFirst(".." + File.separator, "").replaceFirst(".." + File.separator, "")) + ".md#" + (String)object2;
                this.experimentsLink.put(string, (String)object2);
            }
            lightModel.dispose();
            lightModel = null;
        }
        map = null;
        object322 = new LightModel(URI.createURI((String)((IFile)wrappedGamaFile.getResource()).getLocationURI().toString()));
        if (!this.modelsDone.contains(((IFile)wrappedGamaFile.getResource()).getRawLocationURI().toString())) {
            this.modelsDone.add(((IFile)wrappedGamaFile.getResource()).getRawLocationURI().toString());
            iPath = ((IFile)wrappedGamaFile.getResource()).getLocation();
            lightModel = iPath.makeRelativeTo((IPath)new Path(this.indexPath));
            for (String string : ((LightModel)object322).speciesLink.keySet()) {
                String string3 = ((LightModel)object322).speciesLink.get(string);
                string3 = FilenameUtils.removeExtension((String)lightModel.toString().replaceFirst(".." + File.separator, "").replaceFirst(".." + File.separator, "")) + ".md#" + string3;
                this.speciesLink.put(string, string3);
            }
            for (String string : ((LightModel)object322).experimentsLink.keySet()) {
                String string5 = ((LightModel)object322).experimentsLink.get(string);
                string5 = FilenameUtils.removeExtension((String)lightModel.toString().replaceFirst(".." + File.separator, "").replaceFirst(".." + File.separator, "")) + ".md#" + string5;
                this.experimentsLink.put(string, string5);
            }
        }
        iPath = ((IProject)wrappedGamaFile.getProject().getResource()).getLocation();
        lightModel = ((IFile)wrappedGamaFile.getResource()).getLocation();
        String string = FilenameUtils.removeExtension((String)lightModel.makeRelativeTo(iPath).toOSString());
        new File(this.directory + File.separator + string + ".md").getParentFile().mkdirs();
        object = new MarkdownModelDocumentor(wrappedGamaFile, this.directory + File.separator + string + ".md");
        ((MarkdownModelDocumentor)object).generateMarkdown();
        ((MarkdownModelDocumentor)object).saveMarkdown();
        iPath = null;
        lightModel = null;
        Object var6_12 = null;
    }
}

