/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.markdown.visitors;

import gama.experimental.markdown.markdownSyntactic.IParser;
import gama.experimental.markdown.markdownSyntactic.MarkdownTools;
import gama.experimental.markdown.visitors.VisitorActions;
import gama.experimental.markdown.visitors.VisitorAttributes;
import gama.experimental.markdown.visitors.VisitorDebug;
import gama.experimental.markdown.visitors.VisitorDisplays;
import gama.experimental.markdown.visitors.VisitorFacets;
import gama.experimental.markdown.visitors.VisitorParameters;
import gama.experimental.markdown.visitors.VisitorReflexes;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.IDescription;
import java.util.Map;

public class VisitorExperiments
implements ISyntacticElement.SyntacticVisitor {
    StringBuilder mDText;
    VisitorActions visitorActions;
    VisitorAttributes visitorAttributes;
    VisitorFacets visitorFacets;
    VisitorReflexes visitorReflexes = new VisitorReflexes();
    VisitorParameters visitorParameters = new VisitorParameters();
    VisitorDisplays visitorDisplays;
    Map<String, String> speciesLink;
    Map<String, String> experimentsLink;

    public VisitorExperiments(Map<String, String> map, Map<String, String> map2) {
        this.speciesLink = map;
        this.experimentsLink = map2;
        this.visitorActions = new VisitorActions(this.speciesLink, this.experimentsLink);
        this.visitorAttributes = new VisitorAttributes(this.speciesLink, this.experimentsLink);
        this.visitorFacets = new VisitorFacets(this.speciesLink, this.experimentsLink);
        this.visitorDisplays = new VisitorDisplays(this.speciesLink, this.experimentsLink);
    }

    public void visit(ISyntacticElement iSyntacticElement) {
        if (iSyntacticElement.isExperiment()) {
            VisitorDebug.DEBUG("  doing the experiment " + iSyntacticElement.getName());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            Object object = iSyntacticElement.getName();
            if (iSyntacticElement.hasFacet(IParser.GAMA_KEYWORD_TYPE)) {
                object = (String)object + " (" + String.valueOf(iSyntacticElement.getExpressionAt(IParser.GAMA_KEYWORD_TYPE)) + ")";
            }
            this.mDText.append(MarkdownTools.addSubSubHeader(IParser.MARKDOWN_LABEL_EXPERIMENT + IParser.MARKDOWN_KEYWORD_SPACE + (String)object));
            this.visitorFacets.setText(this.mDText);
            iSyntacticElement.visitFacets((IDescription.IFacetVisitor)this.visitorFacets);
            this.mDText = this.visitorFacets.getText();
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addQuote(MarkdownTools.getCommentsFromElement(iSyntacticElement.getElement())));
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_PARAMETERS));
            this.visitorParameters.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorParameters);
            this.mDText = this.visitorParameters.getText();
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_ATTRIBUTES));
            this.visitorAttributes.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorAttributes);
            this.visitorAttributes.first = true;
            this.mDText = this.visitorAttributes.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_REFLEXES));
            this.visitorReflexes.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorReflexes);
            this.visitorReflexes.first = true;
            this.mDText = this.visitorReflexes.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_ACTIONS));
            this.visitorActions.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorActions);
            this.visitorActions.first = true;
            this.mDText = this.visitorActions.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_DISPLAYS));
            this.visitorDisplays.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorDisplays);
            this.mDText = this.visitorDisplays.getText();
        }
    }

    public void setText(StringBuilder stringBuilder) {
        this.mDText = stringBuilder;
    }

    public StringBuilder getText() {
        return this.mDText;
    }

    public void dispose() {
        this.mDText = null;
        this.visitorActions.dispose();
        this.visitorFacets.dispose();
        this.visitorAttributes.dispose();
        this.visitorReflexes.dispose();
        this.visitorParameters.dispose();
        this.visitorDisplays.dispose();
        this.visitorActions = null;
        this.visitorFacets = null;
        this.visitorAttributes = null;
        this.visitorReflexes = null;
        this.visitorParameters = null;
        this.visitorDisplays = null;
        this.experimentsLink = null;
        this.speciesLink = null;
    }
}

