/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.skills;

import dev.langchain4j.mcp.client.DefaultMcpClient;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.experimental.types.Assistant;
import gama.experimental.types.ChatModel;
import gama.experimental.types.ContentRetriever;
import gama.experimental.types.MCPClient;
import gama.experimental.types.MCPTransport;
import gama.experimental.types.Memory;
import gama.experimental.types.ToolProvider;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.skills.Skill;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

@GamlAnnotations.skill(name="llm", concept={"llm"}, doc={@GamlAnnotations.doc(value="The llm skill provides new features that allow agents to ask questions to a chatbot (LLM)")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="llm", type=833237412, init="nil", doc={@GamlAnnotations.doc(value="A chat model (to be built) that can answer questions and be used as a key element of the chat bot")}), @GamlAnnotations.variable(name="chat_bot", type=51715284, init="nil", doc={@GamlAnnotations.doc(value="A chat bot (to be built) that can answer questions taking into account external data (RAG) and trigger actions")}), @GamlAnnotations.variable(name="chat_memory", type=3427233, init="nil", doc={@GamlAnnotations.doc(value="A chat memory (to be built) that can be used to store data for the chat model")})})
public class LLMSkill
extends Skill {
    static {
        DEBUG.ON();
    }

    @GamlAnnotations.action(name="create_ollama_chat_model", args={@GamlAnnotations.arg(name="model_name", type=4, doc={@GamlAnnotations.doc(value=" model_name specifies the exact name or identifier of the language model to be used for generating responses (e.g. 'llama3.2') ")}), @GamlAnnotations.arg(name="url", type=4, doc={@GamlAnnotations.doc(value="url specifies the endpoint URL of the local or remote Ollama server that the model communicates with (for Ollama)")}), @GamlAnnotations.arg(name="response_format", type=4, doc={@GamlAnnotations.doc(value="response_format specifies the format in which the model should return its output, such as plain text or structured JSON. 2 possible values: 'json' or 'text' (by default)")}), @GamlAnnotations.arg(name="num_ctx", type=1, doc={@GamlAnnotations.doc(value="num_ctx specifies the maximum number of context tokens the model can use to process a prompt, including instructions, documents, and conversation history (for Ollama)")}), @GamlAnnotations.arg(name="num_predict", type=1, doc={@GamlAnnotations.doc(value="num_predict specifies the maximum number of tokens the model is allowed to generate in its response (for Ollama)")}), @GamlAnnotations.arg(name="repeat_penalty", type=2, doc={@GamlAnnotations.doc(value="repeat_penalty controls how strongly the model is discouraged from repeating the same tokens or phrases in its response (for Ollama)")}), @GamlAnnotations.arg(name="seed", type=1, doc={@GamlAnnotations.doc(value="seed sets the random number generator seed to make the model\u2019s output deterministic and reproducible")}), @GamlAnnotations.arg(name="temperature", type=2, doc={@GamlAnnotations.doc(value="temperature controls the randomness of the model\u2019s output, with higher values producing more creative and varied responses")}), @GamlAnnotations.arg(name="top_k", type=1, doc={@GamlAnnotations.doc(value="top_k limits the model\u2019s token selection to the top K most probable tokens, influencing the diversity and focus of the generated output (for Ollama)")}), @GamlAnnotations.arg(name="top_p", type=2, doc={@GamlAnnotations.doc(value="top_p (nucleus sampling) sets the probability threshold for choosing the next token, allowing the model to sample from the most likely tokens whose cumulative probability exceeds this value")})}, doc={@GamlAnnotations.doc(value="Action that builds a chat model based on a connection with Ollama", returns="The chat_model built")})
    public ChatModel create_ollama_chat_model(IScope iScope) {
        String string = (String)iScope.getArg("model_name", 4);
        String string2 = (String)iScope.getArg("url", 4);
        String string3 = iScope.hasArg("response_format") ? (String)iScope.getArg("response_format", 4) : null;
        Integer n = iScope.hasArg("seed") ? (Integer)iScope.getArg("seed", 1) : null;
        Integer n2 = iScope.hasArg("num_ctx") ? (Integer)iScope.getArg("num_ctx", 1) : null;
        Double d = iScope.hasArg("temperature") ? (Double)iScope.getArg("temperature", 2) : null;
        Double d2 = iScope.hasArg("top_p") ? (Double)iScope.getArg("top_p", 2) : null;
        Integer n3 = iScope.hasArg("num_predict") ? (Integer)iScope.getArg("num_predict", 1) : null;
        Double d3 = iScope.hasArg("repeat_penalty") ? (Double)iScope.getArg("repeat_penalty", 2) : null;
        Integer n4 = iScope.hasArg("top_k") ? (Integer)iScope.getArg("top_k", 1) : null;
        return new ChatModel(string, string2, string3, n2, n, d, d2, n3, d3, n4);
    }

    @GamlAnnotations.action(name="create_openai_chat_model", args={@GamlAnnotations.arg(name="model_name", type=4, doc={@GamlAnnotations.doc(value=" model_name specifies the exact name or identifier of the language model to be used for generating responses (e.g. 'gpt-4o-mini') ")}), @GamlAnnotations.arg(name="key", type=4, doc={@GamlAnnotations.doc(value="key refers to the API key used to authenticate requests to the OpenAI service (for OpenAi)")}), @GamlAnnotations.arg(name="response_format", type=4, doc={@GamlAnnotations.doc(value="response_format specifies the format in which the model should return its output, such as plain text or structured JSON. 2 possible values: 'json' or 'text' (by default)")}), @GamlAnnotations.arg(name="seed", type=1, doc={@GamlAnnotations.doc(value="seed sets the random number generator seed to make the model\u2019s output deterministic and reproducible")}), @GamlAnnotations.arg(name="temperature", type=2, doc={@GamlAnnotations.doc(value="temperature controls the randomness of the model\u2019s output, with higher values producing more creative and varied responses")}), @GamlAnnotations.arg(name="top_p", type=2, doc={@GamlAnnotations.doc(value="top_p (nucleus sampling) sets the probability threshold for choosing the next token, allowing the model to sample from the most likely tokens whose cumulative probability exceeds this value.")}), @GamlAnnotations.arg(name="frequency_penalty", type=2, doc={@GamlAnnotations.doc(value="frequency_penalty reduces the likelihood of the model repeating tokens by penalizing tokens based on their frequency in the generated text (for OpenAI)")}), @GamlAnnotations.arg(name="max_completion_tokens", type=1, doc={@GamlAnnotations.doc(value="max_completion_tokens sets the maximum number of tokens the model can generate in its completion or response (for OpenAI)")}), @GamlAnnotations.arg(name="max_retries", type=1, doc={@GamlAnnotations.doc(value="max_retries specifies the maximum number of times the system will retry a failed request to the model (for OpenAI)")}), @GamlAnnotations.arg(name="max_tokens", type=1, doc={@GamlAnnotations.doc(value="max_tokens defines the total maximum number of tokens allowed for both the input (prompt) and the output (completion) combined (for OpenAI)")}), @GamlAnnotations.arg(name="presence_penalty", type=2, doc={@GamlAnnotations.doc(value="presence_penalty reduces the likelihood of the model mentioning new topics or tokens that have already appeared, encouraging more diverse and novel content (for OpenAI)")}), @GamlAnnotations.arg(name="store", type=3, doc={@GamlAnnotations.doc(value="store is a boolean that indicates whether the generated data (such as embeddings or chat history) should be saved or not (for OpenAI)")}), @GamlAnnotations.arg(name="timeout", type=1, doc={@GamlAnnotations.doc(value="timeout specifies the maximum amount of time the system will wait for a response from the model before aborting the request (for OpenAI)")})}, doc={@GamlAnnotations.doc(value="Action that builds a chat model based on a connection with OpenAI", returns="The chat_model built")})
    public ChatModel create_openai_chat_model(IScope iScope) {
        String string = (String)iScope.getArg("model_name", 4);
        String string2 = (String)iScope.getArg("key", 4);
        String string3 = iScope.hasArg("response_format") ? (String)iScope.getArg("response_format", 4) : null;
        Double d = iScope.hasArg("frequency_penalty") ? (Double)iScope.getArg("frequency_penalty", 2) : null;
        Integer n = iScope.hasArg("max_completion_tokens") ? (Integer)iScope.getArg("max_completion_tokens", 1) : null;
        Integer n2 = iScope.hasArg("max_retries") ? (Integer)iScope.getArg("max_retries", 1) : null;
        Integer n3 = iScope.hasArg("max_tokens") ? (Integer)iScope.getArg("max_tokens", 1) : null;
        Double d2 = iScope.hasArg("presence_penalty") ? (Double)iScope.getArg("presence_penalty", 2) : null;
        Integer n4 = iScope.hasArg("seed") ? (Integer)iScope.getArg("seed", 1) : null;
        Double d3 = iScope.hasArg("temperature") ? (Double)iScope.getArg("temperature", 2) : null;
        Double d4 = iScope.hasArg("top_p") ? (Double)iScope.getArg("top_p", 2) : null;
        Integer n5 = iScope.hasArg("timeout") ? (Integer)iScope.getArg("timeout", 1) : null;
        Boolean bl = iScope.hasArg("store") ? (Boolean)iScope.getArg("store", 3) : null;
        return new ChatModel(string2, string, string3, d, n, n2, n3, d2, n4, bl, d3, n5, d4);
    }

    @GamlAnnotations.action(name="create_chat_model", args={@GamlAnnotations.arg(name="model_type", type=4, doc={@GamlAnnotations.doc(value="model_type specifies the chat model type: 'openai' or 'ollama'")}), @GamlAnnotations.arg(name="model_name", type=4, doc={@GamlAnnotations.doc(value="model_name specifies the exact name or identifier of the language model to be used for generating responses (e.g. 'gpt-4o-mini')")}), @GamlAnnotations.arg(name="key", type=4, doc={@GamlAnnotations.doc(value="key refers to the API key used to authenticate requests to the OpenAI service (for OpenAi)")}), @GamlAnnotations.arg(name="response_format", type=4, doc={@GamlAnnotations.doc(value="response_format specifies the format in which the model should return its output, such as plain text or structured JSON. 2 possible values: 'json' or 'text' (by default)")}), @GamlAnnotations.arg(name="seed", type=1, doc={@GamlAnnotations.doc(value="seed sets the random number generator seed to make the model\u2019s output deterministic and reproducible")}), @GamlAnnotations.arg(name="temperature", type=2, doc={@GamlAnnotations.doc(value="temperature controls the randomness of the model\u2019s output, with higher values producing more creative and varied responses")}), @GamlAnnotations.arg(name="top_p", type=2, doc={@GamlAnnotations.doc(value="top_p (nucleus sampling) sets the probability threshold for choosing the next token, allowing the model to sample from the most likely tokens whose cumulative probability exceeds this value.")}), @GamlAnnotations.arg(name="frequency_penalty", type=2, doc={@GamlAnnotations.doc(value="frequency_penalty reduces the likelihood of the model repeating tokens by penalizing tokens based on their frequency in the generated text (for OpenAI)")}), @GamlAnnotations.arg(name="max_completion_tokens", type=1, doc={@GamlAnnotations.doc(value="max_completion_tokens sets the maximum number of tokens the model can generate in its completion or response (for OpenAI)")}), @GamlAnnotations.arg(name="max_retries", type=1, doc={@GamlAnnotations.doc(value="max_retries specifies the maximum number of times the system will retry a failed request to the model (for OpenAI)")}), @GamlAnnotations.arg(name="max_tokens", type=1, doc={@GamlAnnotations.doc(value="max_tokens defines the total maximum number of tokens allowed for both the input (prompt) and the output (completion) combined (for OpenAI)")}), @GamlAnnotations.arg(name="presence_penalty", type=2, doc={@GamlAnnotations.doc(value="presence_penalty reduces the likelihood of the model mentioning new topics or tokens that have already appeared, encouraging more diverse and novel content (for OpenAI)")}), @GamlAnnotations.arg(name="store", type=3, doc={@GamlAnnotations.doc(value="tore is a boolean that indicates whether the generated data (such as embeddings or chat history) should be saved or not (for OpenAI)")}), @GamlAnnotations.arg(name="timeout", type=1, doc={@GamlAnnotations.doc(value="timeout specifies the maximum amount of time the system will wait for a response from the model before aborting the request (for OpenAI)")}), @GamlAnnotations.arg(name="url", type=4, doc={@GamlAnnotations.doc(value="url specifies the endpoint URL of the local or remote Ollama server that the model communicates with (for Ollama)")}), @GamlAnnotations.arg(name="num_ctx", type=1, doc={@GamlAnnotations.doc(value="num_ctx specifies the maximum number of context tokens the model can use to process a prompt, including instructions, documents, and conversation history (for Ollama)")}), @GamlAnnotations.arg(name="num_predict", type=1, doc={@GamlAnnotations.doc(value="num_predict specifies the maximum number of tokens the model is allowed to generate in its response (for Ollama)")}), @GamlAnnotations.arg(name="repeat_penalty", type=2, doc={@GamlAnnotations.doc(value="repeat_penalty controls how strongly the model is discouraged from repeating the same tokens or phrases in its response. (for Ollama)")}), @GamlAnnotations.arg(name="top_k", type=1, doc={@GamlAnnotations.doc(value=" top_k limits the model\u2019s token selection to the top K most probable tokens, influencing the diversity and focus of the generated output (for Ollama)")})}, doc={@GamlAnnotations.doc(value="Action that builds a chat model", returns="The chat_model built")})
    public ChatModel create_chat_model(IScope iScope) {
        String string = (String)iScope.getArg("model_type", 4);
        String string2 = (String)iScope.getArg("model_name", 4);
        String string3 = (String)iScope.getArg("url", 4);
        String string4 = (String)iScope.getArg("key", 4);
        if ("openai".equals(string)) {
            String string5 = iScope.hasArg("response_format") ? (String)iScope.getArg("response_format", 4) : null;
            Double d = iScope.hasArg("frequency_penalty") ? (Double)iScope.getArg("frequency_penalty", 2) : null;
            Integer n = iScope.hasArg("max_completion_tokens") ? (Integer)iScope.getArg("max_completion_tokens", 1) : null;
            Integer n2 = iScope.hasArg("max_retries") ? (Integer)iScope.getArg("max_retries", 1) : null;
            Integer n3 = iScope.hasArg("max_tokens") ? (Integer)iScope.getArg("max_tokens", 1) : null;
            Double d2 = iScope.hasArg("presence_penalty") ? (Double)iScope.getArg("presence_penalty", 2) : null;
            Integer n4 = iScope.hasArg("seed") ? (Integer)iScope.getArg("seed", 1) : null;
            Double d3 = iScope.hasArg("temperature") ? (Double)iScope.getArg("temperature", 2) : null;
            Double d4 = iScope.hasArg("top_p") ? (Double)iScope.getArg("top_p", 2) : null;
            Integer n5 = iScope.hasArg("timeout") ? (Integer)iScope.getArg("timeout", 1) : null;
            Boolean bl = iScope.hasArg("store") ? (Boolean)iScope.getArg("store", 3) : null;
            return new ChatModel(string4, string2, string5, d, n, n2, n3, d2, n4, bl, d3, n5, d4);
        }
        String string6 = iScope.hasArg("response_format") ? (String)iScope.getArg("response_format", 4) : null;
        Integer n = iScope.hasArg("seed") ? (Integer)iScope.getArg("seed", 1) : null;
        Integer n6 = iScope.hasArg("num_ctx") ? (Integer)iScope.getArg("num_ctx", 1) : null;
        Double d = iScope.hasArg("temperature") ? (Double)iScope.getArg("temperature", 2) : null;
        Double d5 = iScope.hasArg("top_p") ? (Double)iScope.getArg("top_p", 2) : null;
        Integer n7 = iScope.hasArg("num_predict") ? (Integer)iScope.getArg("num_predict", 1) : null;
        Double d6 = iScope.hasArg("repeat_penalty") ? (Double)iScope.getArg("repeat_penalty", 2) : null;
        Integer n8 = iScope.hasArg("top_k") ? (Integer)iScope.getArg("top_k", 1) : null;
        return new ChatModel(string2, string3, string6, n6, n, d, d5, n7, d6, n8);
    }

    @GamlAnnotations.action(name="create_chat_memory", args={@GamlAnnotations.arg(name="llm", type=833237412, doc={@GamlAnnotations.doc(value="llm specifies the chat model to which the memory will be linked")}), @GamlAnnotations.arg(name="init_memory", type=4, doc={@GamlAnnotations.doc(value="init_memory Specifies the initial content of the memory (by default, blank)")}, optional=true), @GamlAnnotations.arg(name="max_tokens", type=1, doc={@GamlAnnotations.doc(value="max_tokens defines the maximum number of tokens that can be stored or retained in memory to maintain the conversation context (by default: 1000)")}, optional=true)}, doc={@GamlAnnotations.doc(value="Action that builds a memory linked to a chat model \u2014 the memory will be used to construct the message sent to the chat model", returns="The memory built")})
    public Memory create_chat_memory(IScope iScope) {
        ChatModel chatModel = (ChatModel)iScope.getArg("llm", 833237412);
        String string = (String)iScope.getArg("init_memory", 4);
        Integer n = iScope.getIntArg("max_tokens");
        Memory memory = new Memory(chatModel, n);
        memory.addToMemory(string);
        return memory;
    }

    @GamlAnnotations.action(name="create_tool_executor", args={@GamlAnnotations.arg(name="tool_name", type=4, doc={@GamlAnnotations.doc(value="name defines the unique identifier used to reference the tool when it is called by the assistant")}), @GamlAnnotations.arg(name="description", type=4, doc={@GamlAnnotations.doc(value=", description provides a brief explanation of the tool\u2019s purpose to help the assistant understand when and how to use it")}), @GamlAnnotations.arg(name="execute", type=26, doc={@GamlAnnotations.doc(value="execute specifies the GAMA action that must be triggered by the assistant")})}, doc={@GamlAnnotations.doc(value="Action that builds a tool_provider in charge of executing a GAMA action when it is invoked by the assistant during a conversation", returns="The tool_provider built")})
    public ToolProvider create_tool_executor(IScope iScope) {
        ToolProvider toolProvider = new ToolProvider();
        String string = iScope.getStringArg("tool_name");
        String string2 = iScope.getStringArg("description");
        ActionDescription actionDescription = (ActionDescription)iScope.getArg("execute", 26);
        toolProvider.addToolExecutor(iScope, string, string2, actionDescription);
        return toolProvider;
    }

    @GamlAnnotations.action(name="create_tool_executor_from_json", args={@GamlAnnotations.arg(name="json", type=4, doc={@GamlAnnotations.doc(value="name defines the unique identifier used to reference the tool when it is called by the assistant")}), @GamlAnnotations.arg(name="execute", type=26, doc={@GamlAnnotations.doc(value="execute specifies the GAMA action that must be triggered by the assistant")})}, doc={@GamlAnnotations.doc(value="Action that builds a tool_provider in charge of executing a GAMA action when it is invoked by the assistant during a conversation", returns="The tool_provider built")})
    public ToolProvider create_tool_executor_from_json(IScope iScope) {
        ToolProvider toolProvider = new ToolProvider();
        String string = iScope.getStringArg("json");
        ActionDescription actionDescription = (ActionDescription)iScope.getArg("execute", 26);
        toolProvider.addToolExecutor(iScope, string, actionDescription);
        return toolProvider;
    }

    @GamlAnnotations.action(name="add_tool_executor", args={@GamlAnnotations.arg(name="provider", type=146707, doc={@GamlAnnotations.doc(value="provider specifies the tool provider to which the tool executor should be added")}), @GamlAnnotations.arg(name="tool_name", type=4, doc={@GamlAnnotations.doc(value="name defines the unique identifier used to reference the tool when it is called by the assistant")}), @GamlAnnotations.arg(name="description", type=4, doc={@GamlAnnotations.doc(value=", description provides a brief explanation of the tool\u2019s purpose to help the assistant understand when and how to use it")}), @GamlAnnotations.arg(name="execute", type=26, doc={@GamlAnnotations.doc(value="execute specifies the GAMA action that must be triggered by the assistant")})}, doc={@GamlAnnotations.doc(value="Action that executes a command in the OS, as if it is executed from a terminal.", returns="The error message if any")})
    public ToolProvider add_tool_executor(IScope iScope) {
        ToolProvider toolProvider = (ToolProvider)iScope.getArg("provider", 146707);
        String string = iScope.getStringArg("tool_name");
        String string2 = iScope.getStringArg("description");
        ActionDescription actionDescription = (ActionDescription)iScope.getArg("execute", 26);
        toolProvider.addToolExecutor(iScope, string, string2, actionDescription);
        return toolProvider;
    }

    @GamlAnnotations.action(name="add_tool_executor_from_json", args={@GamlAnnotations.arg(name="provider", type=146707, doc={@GamlAnnotations.doc(value="provider specifies the tool provider to which the tool executor should be added")}), @GamlAnnotations.arg(name="json", type=4, doc={@GamlAnnotations.doc(value="name defines the unique identifier used to reference the tool when it is called by the assistant")}), @GamlAnnotations.arg(name="execute", type=26, doc={@GamlAnnotations.doc(value="execute specifies the GAMA action that must be triggered by the assistant")})}, doc={@GamlAnnotations.doc(value="Action that executes a command in the OS, as if it is executed from a terminal.", returns="The error message if any")})
    public ToolProvider add_tool_executor_by_json(IScope iScope) {
        ToolProvider toolProvider = (ToolProvider)iScope.getArg("provider", 146707);
        String string = iScope.getStringArg("json");
        ActionDescription actionDescription = (ActionDescription)iScope.getArg("execute", 26);
        toolProvider.addToolExecutor(iScope, string, actionDescription);
        return toolProvider;
    }

    @GamlAnnotations.action(name="create_client_executor", args={@GamlAnnotations.arg(name="client", type=24373771, doc={@GamlAnnotations.doc(value="client specifies the mcp_client used to connect the assistant to the external tool")})}, doc={@GamlAnnotations.doc(value="Action that builds a tool_provider in charge of executing an external tool  when it is invoked by the assistant during a conversation", returns="The tool_provider built")})
    public ToolProvider create_tool_executor_from_client(IScope iScope) {
        MCPClient mCPClient = (MCPClient)iScope.getArg("client", 24373771);
        return mCPClient == null ? new ToolProvider() : new ToolProvider(mCPClient);
    }

    @GamlAnnotations.action(name="fetch_memory", args={@GamlAnnotations.arg(name="memory", type=3427233, doc={@GamlAnnotations.doc(value="memory specifies the memory to fetch")})}, doc={@GamlAnnotations.doc(value="Action that returns the contents of the memory as a list of strings", returns="A list of strings representing the contents of the memory")})
    public IList<String> fetch_chat_memory(IScope iScope) {
        Memory memory = (Memory)iScope.getArg("memory", 3427233);
        IList iList = GamaListFactory.create();
        memory.getMemory().messages().stream().forEach(chatMessage -> {
            boolean bl = iList.add((Object)chatMessage.toString());
        });
        return iList;
    }

    @GamlAnnotations.action(name="add_to_memory", args={@GamlAnnotations.arg(name="memory", type=3427233, doc={@GamlAnnotations.doc(value="memory specifies the memory to which the message will be added")}), @GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="message that will added to the memory")})}, doc={@GamlAnnotations.doc(value="Action that adds a message to a memory", returns="The message added")})
    public String add_to_chat_memory(IScope iScope) {
        String string = (String)iScope.getArg("message", 4);
        Memory memory = (Memory)iScope.getArg("memory", 3427233);
        if (memory != null) {
            memory.addToMemory(string);
        }
        return string;
    }

    @GamlAnnotations.action(name="send_to_llm_without_memory", args={@GamlAnnotations.arg(name="llm", type=833237412, doc={@GamlAnnotations.doc(value="llm specifies the chat model that will respond to the given message")}, optional=false), @GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="message speficies the prompt sent to the chat model")}, optional=false)}, doc={@GamlAnnotations.doc(value="Action that sends a message (prompt) to a chat_model without taking into account the memory of the chat model", returns="The message returned by the chat model")})
    public String send_to_llm_without_memory(IScope iScope) {
        String string = (String)iScope.getArg("message", 4);
        ChatModel chatModel = (ChatModel)iScope.getArg("llm", 833237412);
        if (chatModel != null) {
            return chatModel.askQuestion(string, false, false, false);
        }
        return "";
    }

    @GamlAnnotations.action(name="send_to_llm", args={@GamlAnnotations.arg(name="llm", type=833237412, doc={@GamlAnnotations.doc(value="llm specifies the chat model that will respond to the given message")}, optional=false), @GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="message speficies the prompt sent to the chat model")}, optional=false), @GamlAnnotations.arg(name="add_message_to_memory", type=3, doc={@GamlAnnotations.doc(value="add_message_to_memory specifies if the message sent has to be added to the memory or not")}, optional=true), @GamlAnnotations.arg(name="add_answer_to_memory", type=3, doc={@GamlAnnotations.doc(value="add_answer_to_memory specifies if the message answered by the chat model has to be added to the memory or not")}, optional=true)}, doc={@GamlAnnotations.doc(value="Action that sends a message (prompt) to a chat_model with taking into account the memory of the chat model", returns="The message returned by the chat model")})
    public String send_to_llm(IScope iScope) {
        boolean bl = iScope.hasArg("add_message_to_memory") ? iScope.getBoolArg("add_message_to_memory") : false;
        boolean bl2 = iScope.hasArg("add_answer_to_memory") ? iScope.getBoolArg("add_answer_to_memory") : false;
        String string = (String)iScope.getArg("message", 4);
        ChatModel chatModel = (ChatModel)iScope.getArg("llm", 833237412);
        if (chatModel != null) {
            return chatModel.askQuestion(string, true, bl, bl2);
        }
        return "";
    }

    @GamlAnnotations.action(name="send_to_assistant", args={@GamlAnnotations.arg(name="assistant", type=51715284, doc={@GamlAnnotations.doc(value="assistant specifies the assistant that will respond to the given message")}), @GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="message speficies the prompt sent to the assistant")})}, doc={@GamlAnnotations.doc(value="Action that sends a message (prompt) to an assistant", returns="The message returned by the assistant")})
    public String send_to_assistant(IScope iScope) {
        String string = (String)iScope.getArg("message", 4);
        Assistant assistant = (Assistant)iScope.getArg("assistant", 51715284);
        return assistant.askQuestion(string);
    }

    @GamlAnnotations.action(name="create_mcp_transport", args={@GamlAnnotations.arg(name="url", type=4, doc={@GamlAnnotations.doc(value="url specifies the endpoint URL used to receive server-sent events (SSE) for real-time communication with the assistant")}), @GamlAnnotations.arg(name="timeout", type=1, doc={@GamlAnnotations.doc(value="timeout defines the maximum duration the client will wait for a response before the request is aborted")})}, doc={@GamlAnnotations.doc(value="Action that builds a mcp_transport, that defines how messages are exchanged between an agent and an assistant, allowing customizable communication mechanisms", returns="The mcp_transport built")})
    public MCPTransport create_mcp_transport(IScope iScope) {
        String string = (String)iScope.getArg("url", 4);
        Integer n = (Integer)iScope.getArg("timeout", 1);
        return new MCPTransport(string, n);
    }

    @GamlAnnotations.action(name="create_mcp_client", args={@GamlAnnotations.arg(name="transport", type=985635271, doc={@GamlAnnotations.doc(value="transport specifies the mcp_transport used for message exchanged")})}, doc={@GamlAnnotations.doc(value="Action that builds a mcp_client, that manages interactions with an assistant by sending messages through the specified mcp_transport and handling the responses", returns="The mcp_client built")})
    public Object create_mcp_client(IScope iScope) {
        MCPTransport mCPTransport = (MCPTransport)iScope.getArg("transport", 985635271);
        DefaultMcpClient defaultMcpClient = new DefaultMcpClient.Builder().transport(mCPTransport.getTransport()).build();
        return defaultMcpClient;
    }

    @GamlAnnotations.action(name="create_assistant", args={@GamlAnnotations.arg(name="llm", type=833237412, doc={@GamlAnnotations.doc(value="llm specifies the chat model used by the assistant")}, optional=false), @GamlAnnotations.arg(name="memory", type=3427233, doc={@GamlAnnotations.doc(value="memory specifies the chat memory used by the assistant (optional)")}, optional=true), @GamlAnnotations.arg(name="tool_provider", type=146707, doc={@GamlAnnotations.doc(value="tool_provider specifies the tools used by the assistant (optional)")}, optional=true), @GamlAnnotations.arg(name="content_retriever", type=933843782, doc={@GamlAnnotations.doc(value="content_retriever specifies the content retriever(RAG) used by the assistant (optional)")}, optional=true)}, doc={@GamlAnnotations.doc(value="Action that builds an LLM assistant, enabling structured interactions with chat models by incorporating memory, RAG, and executor tools", returns="The assistant built")})
    public Assistant create_assistant(IScope iScope) {
        ChatModel chatModel = (ChatModel)iScope.getArg("llm", 833237412);
        ToolProvider toolProvider = iScope.hasArg("tool_provider") ? (ToolProvider)iScope.getArg("tool_provider", 146707) : null;
        ContentRetriever contentRetriever = iScope.hasArg("content_retriever") ? (ContentRetriever)iScope.getArg("content_retriever", 933843782) : null;
        Memory memory = iScope.hasArg("memory") ? (Memory)iScope.getArg("memory", 3427233) : null;
        return new Assistant(chatModel, toolProvider, contentRetriever, memory);
    }

    @GamlAnnotations.action(name="create_rag", args={@GamlAnnotations.arg(name="directoty_path", type=4, doc={@GamlAnnotations.doc(value="path of the directory containing the data")})}, doc={@GamlAnnotations.doc(value="Action that builds a content_retriever contaning the data loaded from the directory path", returns="A content_retriever (RAG) with the specified data; Return nil if the folder does not exist")})
    public ContentRetriever create_rag(IScope iScope) {
        String string = (String)iScope.getArg("directoty_path", 4);
        String string2 = FileUtils.constructAbsoluteFilePath((IScope)GAMA.getRuntimeScope(), (String)string, (boolean)true);
        Path path = Paths.get(string2, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return new ContentRetriever(path);
        }
        GamaRuntimeException.error((String)(string2 + " does not exist or is not a directory"), (IScope)iScope);
        return null;
    }
}

