/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.types;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.service.AiServices;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.experimental.types.ChatModel;
import gama.experimental.types.ContentRetriever;
import gama.experimental.types.Memory;
import gama.experimental.types.ToolProvider;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.vars(value={})
public class Assistant
implements IValue {
    AIAssistant assistant;
    Memory memory = null;
    ChatModel chatModel = null;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "assistant", (Object)this.assistant);
    }

    public Assistant() {
    }

    public Assistant(Assistant assistant) {
    }

    public Assistant(ChatModel chatModel, ToolProvider toolProvider, ContentRetriever contentRetriever, Memory memory) {
        this.chatModel = chatModel;
        AiServices aiServices = AiServices.builder(AIAssistant.class).chatModel(chatModel.getModel());
        if (toolProvider != null) {
            aiServices = aiServices.toolProvider(toolProvider.getToolProvider());
            aiServices.hallucinatedToolNameStrategy(toolExecutionRequest -> ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)("Error: there is no tool called " + toolExecutionRequest.name())));
        }
        if (contentRetriever != null) {
            aiServices = aiServices.contentRetriever(contentRetriever.contentRetriever);
        }
        if (memory != null) {
            this.memory = memory;
            aiServices = aiServices.chatMemory(this.memory.getMemory());
        }
        this.assistant = (AIAssistant)aiServices.build();
    }

    public String askQuestion(String string) {
        return this.assistant.chat(string);
    }

    public AIAssistant getAssistant() {
        return this.assistant;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public ChatModel getChatModel() {
        return this.chatModel;
    }

    public String toString() {
        return "assistant(" + this.assistant.toString() + ")";
    }

    public String serializeToGaml(boolean bl) {
        return this.toString();
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    public Assistant copy(IScope iScope) throws GamaRuntimeException {
        return new Assistant(this);
    }

    public int hashCode() {
        return this.assistant.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Assistant assistant = (Assistant)object;
        return this.assistant.equals(assistant.assistant);
    }

    public IType<?> getGamlType() {
        return Types.get((int)51715284);
    }

    static interface AIAssistant {
        public String chat(String var1);
    }
}

