/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.types;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.experimental.types.Memory;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.time.Duration;
import java.util.ArrayList;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="model_type", type=4, doc={@GamlAnnotations.doc(value="model_type specifies the chat model type: 'openai' or 'ollama'")}), @GamlAnnotations.variable(name="model_name", type=4, doc={@GamlAnnotations.doc(value="model_name specifies the exact name or identifier of the language model to be used for generating responses (e.g. 'gpt-4o-mini') ")}), @GamlAnnotations.variable(name="memory", type=4, doc={@GamlAnnotations.doc(value="memory represents the integrated memory")}), @GamlAnnotations.variable(name="ollama_url", type=4, doc={@GamlAnnotations.doc(value="url specifies the endpoint URL of the local or remote Ollama server that the model communicates with (for Ollama)")}), @GamlAnnotations.variable(name="key", type=4, doc={@GamlAnnotations.doc(value="key refers to the API key used to authenticate requests to the OpenAI service (for OpenAi)")}), @GamlAnnotations.variable(name="response_format", type=4, doc={@GamlAnnotations.doc(value="response_format specifies the format in which the model should return its output, such as plain text or structured JSON. 2 possible values: 'json' or 'text' (by default)")}), @GamlAnnotations.variable(name="num_ctx", type=1, doc={@GamlAnnotations.doc(value="num_ctx specifies the maximum number of context tokens the model can use to process a prompt, including instructions, documents, and conversation history (for Ollama)")}), @GamlAnnotations.variable(name="num_predict", type=1, doc={@GamlAnnotations.doc(value="num_predict specifies the maximum number of tokens the model is allowed to generate in its response (for Ollama)")}), @GamlAnnotations.variable(name="repeat_penalty", type=2, doc={@GamlAnnotations.doc(value="repeat_penalty controls how strongly the model is discouraged from repeating the same tokens or phrases in its response (for Ollama)")}), @GamlAnnotations.variable(name="seed", type=1, doc={@GamlAnnotations.doc(value="seed sets the random number generator seed to make the model\u2019s output deterministic and reproducible")}), @GamlAnnotations.variable(name="temperature", type=2, doc={@GamlAnnotations.doc(value="temperature controls the randomness of the model\u2019s output, with higher values producing more creative and varied responses")}), @GamlAnnotations.variable(name="top_p", type=1, doc={@GamlAnnotations.doc(value="top_k limits the model\u2019s token selection to the top K most probable tokens, influencing the diversity and focus of the generated output (for Ollama)")}), @GamlAnnotations.variable(name="top_k", type=2, doc={@GamlAnnotations.doc(value="top_p (nucleus sampling) sets the probability threshold for choosing the next token, allowing the model to sample from the most likely tokens whose cumulative probability exceeds this value")}), @GamlAnnotations.variable(name="frequency_penalty", type=2, doc={@GamlAnnotations.doc(value="frequency_penalty reduces the likelihood of the model repeating tokens by penalizing tokens based on their frequency in the generated text (for OpenAI)")}), @GamlAnnotations.variable(name="max_completion_tokens", type=1, doc={@GamlAnnotations.doc(value="max_completion_tokens sets the maximum number of tokens the model can generate in its completion or response (for OpenAI)")}), @GamlAnnotations.variable(name="max_retries", type=1, doc={@GamlAnnotations.doc(value="max_retries specifies the maximum number of times the system will retry a failed request to the model (for OpenAI)")}), @GamlAnnotations.variable(name="max_tokens", type=1, doc={@GamlAnnotations.doc(value="max_tokens defines the total maximum number of tokens allowed for both the input (prompt) and the output (completion) combined (for OpenAI)")}), @GamlAnnotations.variable(name="presencePenalty", type=2, doc={@GamlAnnotations.doc(value="presence_penalty reduces the likelihood of the model mentioning new topics or tokens that have already appeared, encouraging more diverse and novel content (for OpenAI)")}), @GamlAnnotations.variable(name="store", type=3, doc={@GamlAnnotations.doc(value="store is a boolean that indicates whether the generated data (such as embeddings or chat history) should be saved or not (for OpenAI)")}), @GamlAnnotations.variable(name="timeout", type=1, doc={@GamlAnnotations.doc(value="timeout specifies the maximum amount of time the system will wait for a response from the model before aborting the request (for OpenAI)")})})
public class ChatModel
implements IValue {
    private String modelType;
    private String modelName;
    private String OllamaUrl;
    private String ApiKey;
    private String responseFormat;
    private Integer numCtx;
    private Integer numPredict;
    private Double repeatPenalty;
    private Integer seed;
    private Double temperature;
    private Integer topK;
    private Double topP;
    private Double frequencyPenalty;
    private Integer maxCompletionTokens;
    private Integer maxRetries;
    private Integer maxTokens;
    private Double presencePenalty;
    private Boolean store;
    private Integer timeOut;
    private dev.langchain4j.model.chat.ChatModel model;
    private Memory memory;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "model", (Object)this.model);
    }

    public ChatModel(String string, String string2, String string3, Integer n, Integer n2, Double d, Double d2, Integer n3, Double d3, Integer n4) {
        OllamaChatModel.OllamaChatModelBuilder ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(string2)).modelName(string);
        if (string3 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.responseFormat(string3.toString().toLowerCase().equals("json") ? ResponseFormat.JSON : ResponseFormat.TEXT);
            this.responseFormat = string3;
        }
        if (n != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.numCtx(n);
            this.numCtx = n;
        }
        if (n3 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.numPredict(n3);
            this.numPredict = n3;
        }
        if (d3 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.repeatPenalty(d3);
            this.repeatPenalty = d3;
        }
        if (n2 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.seed(n2);
            this.seed = n2;
        }
        if (d != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.temperature(d);
            this.temperature = d;
        }
        if (d2 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.topP(d2);
            this.topP = d2;
        }
        if (n4 != null) {
            ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.topK(n4);
            this.topK = n4;
        }
        this.model = ((OllamaChatModel.OllamaChatModelBuilder)ollamaChatModelBuilder.logRequests(Boolean.valueOf(true))).build();
    }

    public ChatModel(String string, String string2, String string3, Double d, Integer n, Integer n2, Integer n3, Double d2, Integer n4, Boolean bl, Double d3, Integer n5, Double d4) {
        OpenAiChatModel.OpenAiChatModelBuilder openAiChatModelBuilder = OpenAiChatModel.builder().apiKey(string).modelName(string2);
        if (string3 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.responseFormat(string3);
            this.responseFormat = string3;
        }
        if (d != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.frequencyPenalty(d);
            this.frequencyPenalty = d;
        }
        if (n != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.maxCompletionTokens(n);
            this.maxCompletionTokens = n;
        }
        if (n2 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.maxRetries(n2);
            this.maxRetries = n2;
        }
        if (n3 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.maxTokens(n3);
            this.maxTokens = n3;
        }
        if (d2 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.presencePenalty(d2);
            this.presencePenalty = d2;
        }
        if (n4 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.seed(n4);
            this.seed = n4;
        }
        if (bl != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.store(bl);
            this.store = bl;
        }
        if (d3 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.temperature(d3);
            this.temperature = d3;
        }
        if (n5 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.timeout(Duration.ofSeconds(n5.intValue()));
            this.timeOut = n5;
        }
        if (d4 != null) {
            openAiChatModelBuilder = openAiChatModelBuilder.topP(d4);
            this.topP = d4;
        }
        this.model = openAiChatModelBuilder.logRequests(Boolean.valueOf(true)).build();
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public String askQuestion(String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl3 && this.memory != null && bl) {
            this.memory.addToMemory(string);
        }
        ArrayList<UserMessage> arrayList = bl3 && this.memory != null ? new ArrayList<UserMessage>(this.memory.getMemory().messages()) : new ArrayList<UserMessage>();
        UserMessage userMessage = UserMessage.from((String)string);
        arrayList.add(userMessage);
        ChatResponse chatResponse = this.model.chat(arrayList);
        if (bl3 && this.memory != null && bl2) {
            this.memory.getMemory().add((ChatMessage)chatResponse.aiMessage());
        }
        return chatResponse.aiMessage().text();
    }

    @GamlAnnotations.getter(value="memory")
    public Memory getMemory() {
        return this.memory;
    }

    @GamlAnnotations.getter(value="model_type")
    public String getModelType() {
        return this.modelType;
    }

    @GamlAnnotations.getter(value="model_name")
    public String getModelName() {
        return this.modelName;
    }

    @GamlAnnotations.getter(value="ollama_url")
    public String getOllamaUrl() {
        return this.OllamaUrl;
    }

    @GamlAnnotations.getter(value="key")
    public String getApiKey() {
        return this.ApiKey;
    }

    @GamlAnnotations.getter(value="response_format")
    public String getResponseFormat() {
        return this.responseFormat;
    }

    @GamlAnnotations.getter(value="num_ctx")
    public Integer getNumCtx() {
        return this.numCtx;
    }

    @GamlAnnotations.getter(value="num_predict")
    public Integer getNiumPredict() {
        return this.numPredict;
    }

    @GamlAnnotations.getter(value="repeat_penalty")
    public Double getRepeatPenalty() {
        return this.repeatPenalty;
    }

    @GamlAnnotations.getter(value="seed")
    public Integer getSeed() {
        return this.seed;
    }

    @GamlAnnotations.getter(value="temperature")
    public Double getTemperature() {
        return this.temperature;
    }

    @GamlAnnotations.getter(value="top_p")
    public Integer getTopK() {
        return this.topK;
    }

    @GamlAnnotations.getter(value="top_k")
    public Double getTopP() {
        return this.topP;
    }

    @GamlAnnotations.getter(value="frequency_penalty")
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @GamlAnnotations.getter(value="max_completion_tokens")
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    @GamlAnnotations.getter(value="max_retries")
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @GamlAnnotations.getter(value="max_tokens")
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @GamlAnnotations.getter(value="presencePenalty")
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    @GamlAnnotations.getter(value="store")
    public Boolean getStore() {
        return this.store;
    }

    @GamlAnnotations.getter(value="timeout")
    public Integer getTimeOut() {
        return this.timeOut;
    }

    public dev.langchain4j.model.chat.ChatModel getModel() {
        return this.model;
    }

    public void setModel(dev.langchain4j.model.chat.ChatModel chatModel) {
        this.model = chatModel;
    }

    public ChatModel() {
    }

    public ChatModel(ChatModel chatModel) {
    }

    public String toString() {
        return "ChatModel(" + this.model.toString() + ")";
    }

    public String serializeToGaml(boolean bl) {
        return this.toString();
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    public ChatModel copy(IScope iScope) throws GamaRuntimeException {
        return new ChatModel(this);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChatModel chatModel = (ChatModel)object;
        return this.model.equals(chatModel.model);
    }

    public IType<?> getGamlType() {
        return Types.get((int)833237412);
    }
}

