/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.types;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.parser.apache.tika.ApacheTikaDocumentParser;
import dev.langchain4j.data.document.source.FileSystemSource;
import dev.langchain4j.internal.Exceptions;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class FileSystemDocumentLoader {
    private static final DocumentParser DEFAULT_DOCUMENT_PARSER = new ApacheTikaDocumentParser();

    private FileSystemDocumentLoader() {
    }

    public static Document loadDocument(Path path, DocumentParser documentParser) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"'%s' is not a file", (Object[])new Object[]{path});
        }
        return DocumentLoader.load((DocumentSource)FileSystemSource.from((Path)path), (DocumentParser)documentParser);
    }

    public static List<Document> loadDocumentsRecursivelyWithExtensions(String string, List<String> list) throws IOException {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        Path path2 = Paths.get(string, new String[0]);
        Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> {
            String string = path.getFileName().toString().toLowerCase();
            return list.stream().anyMatch(string::endsWith);
        }).forEach(path -> {
            try {
                arrayList.add(FileSystemDocumentLoader.loadDocument(path));
            }
            catch (Exception exception) {
                System.err.println("Erreur lors du chargement de : " + String.valueOf(path) + " -> " + exception.getMessage());
            }
        });
        return arrayList;
    }

    public static Document loadTxtFile(Path path) throws IOException {
        String string = Files.readString(path);
        if (string.trim().isEmpty()) {
            throw new RuntimeException("Le fichier est vide : " + String.valueOf(path));
        }
        return Document.from((String)string);
    }

    public static List<Document> loadAllFromDirectory(Path path2) throws IOException {
        return Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".txt")).map(path -> {
            try {
                return FileSystemDocumentLoader.loadTxtFile(path);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Erreur lecture : " + String.valueOf(path), iOException);
            }
        }).toList();
    }

    public static Document loadDocument(Path path) {
        return FileSystemDocumentLoader.loadDocument(path, DEFAULT_DOCUMENT_PARSER);
    }

    public static Document loadDocument(String string, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocument(Paths.get(string, new String[0]), documentParser);
    }

    public static Document loadDocument(String string) {
        return FileSystemDocumentLoader.loadDocument(string, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocuments(Path path2, DocumentParser documentParser) {
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"'%s' is not a directory", (Object[])new Object[]{path2});
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.list(path2);){
                return FileSystemDocumentLoader.loadDocuments(stream, path -> true, path2, documentParser);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static List<Document> loadDocuments(Path path) {
        return FileSystemDocumentLoader.loadDocuments(path, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocuments(String string, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(string, new String[0]), documentParser);
    }

    public static List<Document> loadDocuments(String string) {
        return FileSystemDocumentLoader.loadDocuments(string, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocuments(Path path, PathMatcher pathMatcher, DocumentParser documentParser) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"'%s' is not a directory", (Object[])new Object[]{path});
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> stream = Files.list(path);){
                return FileSystemDocumentLoader.loadDocuments(stream, pathMatcher, path, documentParser);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static List<Document> loadDocuments(Path path, PathMatcher pathMatcher) {
        return FileSystemDocumentLoader.loadDocuments(path, pathMatcher, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocuments(String string, PathMatcher pathMatcher, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(string, new String[0]), pathMatcher, documentParser);
    }

    public static List<Document> loadDocuments(String string, PathMatcher pathMatcher) {
        return FileSystemDocumentLoader.loadDocuments(string, pathMatcher, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocumentsRecursively(Path path2, DocumentParser documentParser) {
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"'%s' is not a directory", (Object[])new Object[]{path2});
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                return FileSystemDocumentLoader.loadDocuments(stream, path -> true, path2, documentParser);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static List<Document> loadDocumentsRecursively(Path path) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(path, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocumentsRecursively(String string, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(Paths.get(string, new String[0]), documentParser);
    }

    public static List<Document> loadDocumentsRecursively(String string) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(string, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocumentsRecursively(Path path, PathMatcher pathMatcher, DocumentParser documentParser) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"'%s' is not a directory", (Object[])new Object[]{path});
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                return FileSystemDocumentLoader.loadDocuments(stream, pathMatcher, path, documentParser);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static List<Document> loadDocumentsRecursively(Path path, PathMatcher pathMatcher) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(path, pathMatcher, DEFAULT_DOCUMENT_PARSER);
    }

    public static List<Document> loadDocumentsRecursively(String string, PathMatcher pathMatcher, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(Paths.get(string, new String[0]), pathMatcher, documentParser);
    }

    public static List<Document> loadDocumentsRecursively(String string, PathMatcher pathMatcher) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(string, pathMatcher, DEFAULT_DOCUMENT_PARSER);
    }

    private static List<Document> loadDocuments(Stream<Path> stream, PathMatcher pathMatcher, Path path2, DocumentParser documentParser) {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(path2::relativize).filter(pathMatcher::matches).map(path2::resolve).forEach(path -> {
            try {
                Document document = FileSystemDocumentLoader.loadDocument(path, documentParser);
                arrayList.add(document);
            }
            catch (BlankDocumentException blankDocumentException) {
            }
            catch (Exception exception) {
                String string = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
                System.err.println("message: " + string);
            }
        });
        return arrayList;
    }
}

